import { EventEmitter, OnInit } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { NwfSchemaColumn } from '../../schema/schema';
/**
 * A filter criterion consist of filter property, operator and a value.
 * Each filter-property have a list of operators.
 * Filter criterion row gets a critierion(filter) from parent filterGroup, and it breaks that criterion down into property, operator and a value.
 * Filter property and type means same thing and are interchangeable
 */
export declare class FilterCriterionRowComponent implements OnInit {
    dxColumns: NwfSchemaColumn[][];
    criteria: FormGroup;
    deleteCriterion: EventEmitter<any>;
    selectedColumn: any;
    propertyTypeConfig: any;
    config: any;
    /**
     * Track operator changes to set default and remove defaults based on changes
     */
    previousOperator: any;
    constructor();
    ngOnInit(): void;
    /**
     * @description method to set the operator and value of a particular criterion when property dropdown value is changed.
     * Whenever we change the filter property, we update the operator and reset the value associated with the filter, so that we can start fresh for the new filter.
     * @param id
     */
    updateCriterion(): void;
    updateOperator(change: any): void;
    /**
     * Method to get the default filter critierion based on filter property.
     * @param property Filter property (type)
     */
    private initCriterion;
    /**
     * This method finds the property to be set to individual criterion
     * from properties passed-in.
     */
    private setColumnBasedOnCriteria;
}
