import { OnChanges, SimpleChanges } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
export declare class FilterMultiselectComponent implements OnChanges, ControlValueAccessor {
    options: any[];
    id: string;
    valueModel: any;
    private _optionsIconClasses;
    private _onChange;
    private _valDelimiter;
    ngOnChanges(changes: SimpleChanges): void;
    /**
     * Writes a new value to the element.
     * This method will be called by the forms API to write to the view when programmatic (model -> view) changes are requested.
     * This is incoming 'value' into the component. This value is pre-set value to multiselect.
     * @param value
     */
    writeValue(value: any): void;
    registerOnChange(fn: any): void;
    registerOnTouched(fn: any): void;
    /**
     * This method is called whenever model tied to the component changes. This invoked change handler on the component
     * that can be handled by the widget's consumer.
     * This is outgoing value from this widget.
     */
    onValueModelChange(): void;
    /**
     * This method sets the icon next to option label.
     * It also sets all checkboxes to false initially.
     */
    setOptionIcons(): void;
}
