"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var angular = require("angular");
var DatetimeRangePickerController = /** @class */ (function () {
    function DatetimeRangePickerController($filter) {
        var _this = this;
        this.isPopoverOpen = false;
        // The
        this.datepickerOptions = {
            showWeeks: false,
            maxMode: 'month',
            minDate: null,
            maxDate: null
        };
        // Connecting our outsideClick handler ourselves
        var bodyEl = this.bodyEl = document.body;
        var onBodyClick = function (evt) {
            /* I check the event's target has any parentage who's class begins with nwf-column-chooser-
                that way I can differentiate any clicks that are not inside my widget, and cause
                the parent popover to come down.
                This selector here is - any element who's class attribute starts with nwf-column-chooser-
             */
            var target = angular.element(evt.target);
            if (target.closest('.datetimepicker-button').length) {
                return;
            }
            else {
                _this.isPopoverOpen = false;
            }
        };
        this.onBodyClick = bodyEl.addEventListener('click', onBodyClick);
        this.i18nFormat = $filter('i18nextFormat');
    }
    DatetimeRangePickerController.prototype.$onInit = function () {
        this.datetimeRangeVisibleValue = this.i18nFormat(this.fromDate) + ' to ' + this.i18nFormat(this.toDate);
        //make two copies of my datepicker options defaulted but we  change inside
        this._fromDatepickerOptions = angular.extend({}, this.datepickerOptions);
        this._toDatepickerOptions = angular.extend({}, this.datepickerOptions);
    };
    DatetimeRangePickerController.prototype.$onDestroy = function () {
        this.bodyEl.removeEventListener('click', this.onBodyClick);
    };
    DatetimeRangePickerController.prototype.setFromDatetime = function (newStartDate) {
        this.fromDate = newStartDate;
        this._toDatepickerOptions.minDate = newStartDate;
        this.setDatetimeRange();
    };
    DatetimeRangePickerController.prototype.setToDatetime = function (toDate) {
        this.toDate = toDate;
        this._fromDatepickerOptions.maxDate = toDate;
        this.setDatetimeRange();
    };
    DatetimeRangePickerController.prototype.setDatetimeRange = function () {
        //create comma-separated range.
        var datetimeRange = this.i18nFormat(this.fromDate) + '~' + this.i18nFormat(this.toDate);
        this.datetimeRangeVisibleValue = this.i18nFormat(this.fromDate) + ' to ' + this.i18nFormat(this.toDate);
        //calling callback with sending the datetime range.
        this.changeDatetimeRangeCallback({
            $datetimeRange: datetimeRange
        });
    };
    DatetimeRangePickerController.prototype.togglePopover = function () {
        this.isPopoverOpen = !this.isPopoverOpen;
    };
    DatetimeRangePickerController.$inject = ['$filter'];
    return DatetimeRangePickerController;
}());
exports.default = DatetimeRangePickerController;
//# sourceMappingURL=datetimeRangePicker-controller.js.map