"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var NwfFormDirtyCheckController = /** @class */ (function () {
    function NwfFormDirtyCheckController($element, $transitions, $scope, $rootScope, $i18next) {
        var _this = this;
        this.$element = $element;
        this.$transitions = $transitions;
        this.$scope = $scope;
        this.$rootScope = $rootScope;
        this.$i18next = $i18next;
        this.element = $element[0];
        this.hasBeenSubmitted = false;
        //We do a watch on number of elements in the form and if they change, we veroify whether default value has been set,
        // if not, we set the default value.
        $scope.$watch(function () {
            return _this.element.elements.length;
        }, function (newVal, oldVal) {
            if (newVal) {
                var elements = _this.element.elements;
                for (var i = 0; i < elements.length; i++) {
                    var element = elements[i];
                    // This only applies for textboxes, textarea, hidden, password, checkboxes.
                    // We look for default value being set or not. If its not then we fetch ng-models value
                    // from element and set it to default value.
                    if (element.defaultValue === '' && element.hasAttribute('ng-model')) {
                        var myNgModel = element.getAttribute('ng-model');
                        // this is used to get scope properties in case we have tree of nested scope properties assigned to ng-model
                        var scopeValue = _this.getDescendantProperties($scope, myNgModel);
                        // if element has a scope value ie. ng-model is set, we set a default value to scope value.
                        if (scopeValue) {
                            element.defaultValue = scopeValue;
                            element.defaultChecked = scopeValue;
                        }
                    }
                }
            }
        });
        $element.on('submit', function () {
            //On Submit, we set the submitted to true and also set the initial form value to the value on submission of the form.
            _this.hasBeenSubmitted = true;
        });
        /* When I die, I break down my stateChange handler */
        $scope.$on('$destroy', function () {
            _this.stateChangeStartTransition();
        });
        /* stateTransitions tell me when to leave */
        this.stateChangeStartTransition = $transitions.onStart({}, function (transition) {
            if (_this.dirtyCheck()) {
                if (confirm($i18next.t("nwfjs:formDirtyCheckConfirm"))) {
                    //OK case. nothing comes here. since we want it to go back.
                }
                else {
                    return false;
                }
            }
        });
    }
    NwfFormDirtyCheckController.prototype.formDirtyCheck = function (form) {
        for (var i = 0; i < form.elements.length; i++) {
            var element = form.elements[i];
            var type = element.type;
            if (type == "checkbox" || type == "radio") {
                if (element.checked != element.defaultChecked) {
                    return true;
                }
            }
            else if (type == "hidden" || type == "password" ||
                type == "text" || type == "textarea") {
                if (element.value != element.defaultValue) {
                    return true;
                }
            }
            else if (type == "select-one" || type == "select-multiple") {
                for (var j = 0; j < element.options.length; j++) {
                    if (element.options[j].selected !=
                        element.options[j].defaultSelected) {
                        return true;
                    }
                }
            }
        }
        return false;
    };
    NwfFormDirtyCheckController.prototype.dirtyCheck = function () {
        var isDirty = false;
        var val = this.$element.attr('disabled');
        //we do a dirty check only if form is enabled (i.e. not disabled), since then only the form can be in a dirty state.
        if (val !== 'disabled' && !(this.hasBeenSubmitted)) {
            if (this.formDirtyCheck(this.$element[0])) {
                isDirty = true;
                this.hasBeenSubmitted = false;
            }
        }
        return isDirty;
    };
    ;
    NwfFormDirtyCheckController.prototype.getDescendantProperties = function (obj, desc) {
        var arr = desc.split(".");
        while (arr.length && (obj = obj[arr.shift()]))
            ;
        return obj;
    };
    NwfFormDirtyCheckController.$inject = ['$element', '$transitions', '$scope', '$rootScope', '$i18next'];
    return NwfFormDirtyCheckController;
}());
exports.default = NwfFormDirtyCheckController;
//# sourceMappingURL=formDirtyCheck-controller.js.map