"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var NwfFormElementController = /** @class */ (function () {
    function NwfFormElementController($element, $window, $attrs) {
        this.$element = $element;
        this.$window = $window;
        this.$attrs = $attrs;
        this.element = $element[0];
    }
    NwfFormElementController.prototype.$onInit = function () {
        var _this = this;
        // Observing 'disabled' attribute on element, and removing invalidState on the element if its disabled.
        this.$attrs.$observe('disabled', function (newVal) {
            if (newVal) {
                _this.removeInvalidState();
            }
        });
        // On input: Now I connect the events oninput provides real time immediate feedback on each key
        var inputHandler = this.inputHandler.bind(this);
        this.element.addEventListener('input', inputHandler);
        // On invalid
        var invalidHandler = this.invalidHandler.bind(this);
        this.element.addEventListener('invalid', invalidHandler);
        // On blur
        var blurHandler = this.blurHandler.bind(this);
        this.element.addEventListener('blur', blurHandler);
        // On focus
        var focusHandler = this.focusHandler.bind(this);
        this.element.addEventListener('focus', focusHandler);
        //on Change
        var changeHandler = this.changeHandler.bind(this);
        this.element.addEventListener('change', changeHandler);
        this.$element.on('$destroy', function () {
            _this.element.removeEventListener('input', inputHandler);
            _this.element.removeEventListener('invalid', invalidHandler);
            _this.element.removeEventListener('blur', blurHandler);
            _this.element.removeEventListener('focus', focusHandler);
            _this.element.removeEventListener('change', changeHandler);
        });
    };
    //Create invalid icon.
    NwfFormElementController.prototype.setInvalidState = function () {
        this.element.classList.add('is-invalid');
    };
    //Remove invalid icon.
    NwfFormElementController.prototype.removeInvalidState = function () {
        // Delete the invalid icon node.
        this.element.classList.remove('is-invalid');
    };
    //Show the tooltip on the DOM
    NwfFormElementController.prototype.showToolTip = function () {
        if (this.element.reportValidity) {
            this.element.reportValidity();
            return;
        }
        //var w = window;
        var w = this.$window;
        var isIE = w.ActiveXObject || "ActiveXObject" in w;
        var isFF = w.navigator.userAgent.toLowerCase().indexOf('firefox') > -1;
        if (this.element.submitButtonClicked && (isIE || isFF)) {
            if (isFF) {
                delete this.element.submitButtonClicked;
            }
            return;
        }
        /* Showing the tip ourselves! */
        if (!this.element.myValidationTooltip) {
            this.element.parentNode.classList.add("tooltip-wrapper");
            var i = document.createElement('div');
            i.className = 'report-validity-tooltip';
            i.innerHTML = this.element.validationMessage;
            // Add the tip to the dom
            this.element.parentNode.appendChild(i);
            this.element.myValidationTooltip = i;
        }
    };
    NwfFormElementController.prototype.removeTip = function () {
        if (this.element.myValidationTooltip) {
            this.element.parentNode.classList.remove("tooltip-wrapper");
            this.element.myValidationTooltip.parentNode.removeChild(this.element.myValidationTooltip);
            delete this.element.myValidationTooltip;
        }
    };
    //updateValidity can be called at will to update the ui affordances
    NwfFormElementController.prototype.updateValidity = function (isFocused) {
        /* First I show my tip, if I am invalid and focused, and I don't show tips on Selects, since they are covered up anyway by the select menu itself. */
        if (!this.element.validity.valid && this.element.hasBeenBlurred && isFocused && this.element.tagName !== 'SELECT') {
            this.showToolTip();
        }
        else {
            this.removeTip();
        }
        /* If I am not valid so set my state if I am not valid and have been blurred, or not valid and submitClicked (set in invalid handler) */
        if (!this.element.validity.valid && this.element.hasBeenBlurred || !this.element.validity.valid && this.element.submitButtonClicked) {
            this.setInvalidState();
        }
        else {
            this.removeInvalidState();
        }
    };
    //input blurHandler
    NwfFormElementController.prototype.inputHandler = function () {
        this.updateValidity(true);
    };
    //Blur Handler
    NwfFormElementController.prototype.blurHandler = function () {
        /* We set this flag so that when first go in, it doesn't yell. Don't yell I haven't done anything wrong yet! */
        if (!this.element.hasBeenBlurred) {
            this.element.hasBeenBlurred = true;
        }
        this.updateValidity(false);
    };
    //Focus Handler
    NwfFormElementController.prototype.focusHandler = function () {
        this.updateValidity(true);
    };
    NwfFormElementController.prototype.invalidHandler = function () {
        this.element.submitButtonClicked = true;
        /* We have to call this to apply our states when native val happens */
        this.updateValidity(false);
    };
    NwfFormElementController.prototype.changeHandler = function () {
        if (this.element.tagName == 'SELECT') {
            if (this.element.value) {
                this.removeInvalidState();
                this.element.setCustomValidity('');
            }
            else {
                this.setInvalidState();
            }
        }
    };
    NwfFormElementController.$inject = ['$element', '$window', '$attrs'];
    return NwfFormElementController;
}());
exports.default = NwfFormElementController;
//# sourceMappingURL=formElement-controller.js.map