export declare class NwfFormLayoutBase {
    restrict: string;
    transclude: boolean;
    replace: boolean;
}
/**
 * @ngdoc directive
 * @name form-row directive
 * @description This directive is the implementation a form row
 * a form row is a construct that groups a form control and it's label (form label) together so that they present a row in the form
 * @example <form-row><form-label><label for="policyname">Small Policy Name</label>
 *              </form-label><form-control><input type="text" name="policyname" id="policyname">
 *          </form-control></form-row>
 *
 */
export declare class NwfFormRow extends NwfFormLayoutBase {
    static NAME: string;
    template: string;
}
export declare function NwfFormRowFactory(): NwfFormRow;
export declare class NwfInlineBlockForm extends NwfFormLayoutBase {
    static NAME: string;
    template: string;
}
export declare function NwfInlineBlockFormFactory(): NwfInlineBlockForm;
export declare class NwfInlineForm extends NwfFormLayoutBase {
    static NAME: string;
    template: string;
}
export declare function NwfInlineFormFactory(): NwfInlineForm;
