"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var NwfFormLayoutBase = /** @class */ (function () {
    function NwfFormLayoutBase() {
        this.restrict = 'E';
        this.transclude = true;
        this.replace = true;
    }
    return NwfFormLayoutBase;
}());
exports.NwfFormLayoutBase = NwfFormLayoutBase;
/**
 * @ngdoc directive
 * @name form-row directive
 * @description This directive is the implementation a form row
 * a form row is a construct that groups a form control and it's label (form label) together so that they present a row in the form
 * @example <form-row><form-label><label for="policyname">Small Policy Name</label>
 *              </form-label><form-control><input type="text" name="policyname" id="policyname">
 *          </form-control></form-row>
 *
 */
/* Form Row */
var NwfFormRow = /** @class */ (function (_super) {
    __extends(NwfFormRow, _super);
    function NwfFormRow() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.template = '<dl class="l-form-row" ng-transclude></dl>';
        return _this;
    }
    NwfFormRow.NAME = 'formRow';
    return NwfFormRow;
}(NwfFormLayoutBase));
exports.NwfFormRow = NwfFormRow;
function NwfFormRowFactory() {
    return new NwfFormRow();
}
exports.NwfFormRowFactory = NwfFormRowFactory;
/* Inline Block Form */
var NwfInlineBlockForm = /** @class */ (function (_super) {
    __extends(NwfInlineBlockForm, _super);
    function NwfInlineBlockForm() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.template = '<div class="l-inline-block-form" ng-transclude></div>';
        return _this;
    }
    NwfInlineBlockForm.NAME = 'inlineBlockForm';
    return NwfInlineBlockForm;
}(NwfFormLayoutBase));
exports.NwfInlineBlockForm = NwfInlineBlockForm;
function NwfInlineBlockFormFactory() {
    return new NwfInlineBlockForm();
}
exports.NwfInlineBlockFormFactory = NwfInlineBlockFormFactory;
/* Inline Form */
var NwfInlineForm = /** @class */ (function (_super) {
    __extends(NwfInlineForm, _super);
    function NwfInlineForm() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.template = '<div class="l-inline-form" ng-transclude></div>';
        return _this;
    }
    NwfInlineForm.NAME = 'inlineForm';
    return NwfInlineForm;
}(NwfFormLayoutBase));
exports.NwfInlineForm = NwfInlineForm;
function NwfInlineFormFactory() {
    return new NwfInlineForm();
}
exports.NwfInlineFormFactory = NwfInlineFormFactory;
//# sourceMappingURL=formLayout-directives.js.map