"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var angular = require("angular");
var formControl_directives_1 = require("./components/formControl-directives");
var formLayout_directives_1 = require("./components/formLayout-directives");
var formValidation_directives_1 = require("./components/formValidation-directives");
var isRequired_directive_1 = require("./validators/isRequired-directive");
var isNumber_directive_1 = require("./validators/isNumber-directive");
var isEmail_directive_1 = require("./validators/isEmail-directive");
var isPattern_directive_1 = require("./validators/isPattern-directive");
var isSame_directive_1 = require("./validators/isSame-directive");
var isFuncTrue_directive_1 = require("./validators/isFuncTrue-directive");
var datetimePicker_component_1 = require("./components/datetimePicker-component");
var FormModule = /** @class */ (function () {
    function FormModule() {
        this.native = angular.module(FormModule.NAME, FormModule.DEPENDENCIES);
        this.native.directive(formControl_directives_1.NwfFormControl.NAME, formControl_directives_1.NwfFormControlFactory);
        this.native.directive(formControl_directives_1.NwfFormSection.NAME, formControl_directives_1.NwfFormSectionFactory);
        this.native.directive(formControl_directives_1.NwfFormLabel.NAME, formControl_directives_1.NwfFormLabelFactory);
        this.native.directive(formLayout_directives_1.NwfFormRow.NAME, formLayout_directives_1.NwfFormRowFactory);
        this.native.directive(formLayout_directives_1.NwfInlineBlockForm.NAME, formLayout_directives_1.NwfInlineBlockFormFactory);
        this.native.directive(formLayout_directives_1.NwfInlineForm.NAME, formLayout_directives_1.NwfInlineFormFactory);
        this.native.directive(formValidation_directives_1.NwfFormElement.NAME, formValidation_directives_1.NwfFormElementFactory);
        this.native.directive(formValidation_directives_1.NwfFormDirtyCheck.NAME, formValidation_directives_1.NwfFormDirtyCheckFactory);
        this.native.directive(isRequired_directive_1.IsRequiredValidator.NAME, isRequired_directive_1.IsRequiredValidatorFactory);
        this.native.directive(isNumber_directive_1.IsNumberValidator.NAME, isNumber_directive_1.IsNumberValidatorFactory);
        this.native.directive(isEmail_directive_1.IsEmailValidator.NAME, isEmail_directive_1.IsEmailValidatorFactory);
        this.native.directive(isPattern_directive_1.IsPatternValidator.NAME, isPattern_directive_1.IsPatternValidatorFactory);
        this.native.directive(isSame_directive_1.IsSameValidator.NAME, isSame_directive_1.IsSameValidatorFactory);
        this.native.directive(isFuncTrue_directive_1.IsFuncTrueValidator.NAME, isFuncTrue_directive_1.IsFuncTrueValidatorFactory);
        this.native.component(datetimePicker_component_1.default.NAME, new datetimePicker_component_1.default());
    }
    FormModule.NAME = 'nwfFormModule';
    FormModule.DEPENDENCIES = [];
    return FormModule;
}());
exports.default = FormModule;
//# sourceMappingURL=form-module.js.map