"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var NwfValidator = /** @class */ (function () {
    function NwfValidator($element) {
        this.myEl = $element[0];
    }
    NwfValidator.prototype.$onInit = function () {
        var elType = this.myEl.type;
        // Checkboxes don't need invalid handler
        if (elType !== 'checkbox') {
            this.myEl.addEventListener('invalid', this.invalidHandler.bind(this));
        }
        else {
            this.myEl.addEventListener('change', this.resetCustomValidity.bind(this));
        }
        this.myEl.addEventListener('input', this.resetCustomValidity.bind(this));
        /* I added this DOMAutoComplete event due to Firefox autofilling the login page, and the html validation not getting reset
           This caused the html5 validation logic to not work, because it was filled but not triggering the resetting.
        */
        this.myEl.addEventListener('DOMAutoComplete', this.resetCustomValidity.bind(this));
        // Checkboxes need their values set
        if (elType == 'checkbox') {
            this.myEl.setCustomValidity(this.emptyMessage);
        }
    };
    NwfValidator.prototype.invalidHandler = function () {
        var msg = '';
        if (this.myEl.validity.valueMissing) {
            msg = this.emptyMessage;
        }
        else if (!this.myEl.validity.valid) {
            msg = this.invalidMessage;
        }
        this.myEl.setCustomValidity(msg);
    };
    NwfValidator.prototype.resetCustomValidity = function () {
        // First I reset
        this.myEl.setCustomValidity('');
        // Then I call my invalidHandler
        this.invalidHandler();
    };
    NwfValidator.$inject = ['$element'];
    return NwfValidator;
}());
exports.default = NwfValidator;
//# sourceMappingURL=nwfValidator.js.map