"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var nwfValidator_1 = require("../nwfValidator");
var IsEmailValidatorController = /** @class */ (function (_super) {
    __extends(IsEmailValidatorController, _super);
    function IsEmailValidatorController($element, $i18next) {
        var _this = _super.call(this, $element) || this;
        _this.$element = $element;
        _this.$i18next = $i18next;
        _this.myEl.setAttribute('type', 'email');
        _this.myEl.setAttribute('multiple', 'multiple');
        _this.invalidMessage = _this.invalidMessage || $i18next.t('nwfjs:isEmailInvalidMessage');
        _this.emptyMessage = _this.emptyMessage || $i18next.t('nwfjs:emptyMessage');
        return _this;
    }
    IsEmailValidatorController.prototype.invalidHandler = function () {
        if (this.myEl.validity.valueMissing && !this.myEl.validity.badInput) {
            this.myEl.setCustomValidity(this.emptyMessage);
        }
        else if (!this.myEl.validity.valid) {
            // if a semi-colon exists in the value of the textbox, we display comma-separated error.
            if (this.myEl.value.indexOf(';') > -1) {
                this.myEl.setCustomValidity(this.$i18next.t('nwfjs:isEmailMultipleInvalidMessage'));
            }
            else {
                this.myEl.setCustomValidity(this.invalidMessage);
            }
        }
        else {
            this.myEl.setCustomValidity('');
        }
    };
    IsEmailValidatorController.$inject = ['$element', '$i18next'];
    return IsEmailValidatorController;
}(nwfValidator_1.default));
exports.IsEmailValidatorController = IsEmailValidatorController;
var IsEmailValidator = /** @class */ (function () {
    function IsEmailValidator() {
        this.bindToController = {
            emptyMessage: '@?',
            invalidMessage: '@?'
        };
        this.restrict = 'A';
        this.controller = IsEmailValidatorController;
        this.controllerAs = 'emailCtrl';
    }
    IsEmailValidator.NAME = 'isEmail';
    return IsEmailValidator;
}());
exports.IsEmailValidator = IsEmailValidator;
// export factory function
function IsEmailValidatorFactory() {
    return new IsEmailValidator();
}
exports.IsEmailValidatorFactory = IsEmailValidatorFactory;
//# sourceMappingURL=isEmail-directive.js.map