"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var nwfValidator_1 = require("../nwfValidator");
var IsPatternValidatorController = /** @class */ (function (_super) {
    __extends(IsPatternValidatorController, _super);
    function IsPatternValidatorController($element, $i18next) {
        var _this = _super.call(this, $element) || this;
        _this.$element = $element;
        _this.$i18next = $i18next;
        _this.invalidMessage = _this.invalidMessage || $i18next.t('nwfjs:isPatternInvalidMessage');
        _this.emptyMessage = _this.emptyMessage || $i18next.t('nwfjs:emptyMessage');
        return _this;
    }
    IsPatternValidatorController.prototype.invalidHandler = function () {
        if (this.myEl.validity.valueMissing) {
            this.myEl.setCustomValidity(this.emptyMessage);
        }
        else if (!this.myEl.validity.valid && this.myEl.validity.patternMismatch) {
            this.myEl.setCustomValidity(this.invalidMessage);
        }
        else {
            this.myEl.setCustomValidity('');
        }
        //setting 'title' attribute to empty string.
        this.myEl.setAttribute('title', '');
    };
    IsPatternValidatorController.$inject = ['$element', '$i18next'];
    return IsPatternValidatorController;
}(nwfValidator_1.default));
exports.IsPatternValidatorController = IsPatternValidatorController;
var IsPatternValidator = /** @class */ (function () {
    function IsPatternValidator() {
        this.bindToController = {
            emptyMessage: '@?',
            invalidMessage: '@?'
        };
        this.restrict = 'A';
        this.controller = IsPatternValidatorController;
        this.controllerAs = 'patternCtrl';
    }
    IsPatternValidator.NAME = 'isPattern';
    return IsPatternValidator;
}());
exports.IsPatternValidator = IsPatternValidator;
// export factory function
function IsPatternValidatorFactory() {
    return new IsPatternValidator();
}
exports.IsPatternValidatorFactory = IsPatternValidatorFactory;
//# sourceMappingURL=isPattern-directive.js.map