"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var nwfValidator_1 = require("../nwfValidator");
var IsSameValidatorController = /** @class */ (function (_super) {
    __extends(IsSameValidatorController, _super);
    function IsSameValidatorController($element, $i18next) {
        var _this = _super.call(this, $element) || this;
        _this.$element = $element;
        _this.invalidMessage = _this.invalidMessage || $i18next.t('nwfjs:isSameInvalidMessage');
        _this.emptyMessage = _this.emptyMessage || $i18next.t('nwfjs:emptyMessage');
        return _this;
    }
    IsSameValidatorController.prototype.$onInit = function () {
        var _this = this;
        _super.prototype.$onInit.call(this);
        //I connect events to the masterElement so if it changes somehow, I reset and revalidate MY (this) validity, and trigger validation when the master changes
        this.masterElement = document.getElementById(this.isSame);
        var inputHandler = this.resetCustomValidity.bind(this);
        this.masterElement.addEventListener('input', inputHandler);
        var blurHandler = function () {
            _this.$element.trigger('focus');
            if (_this.$element[0]['hasBeenBlurred']) {
                _this.$element.trigger('blur');
            }
        };
        this.masterElement.addEventListener('blur', blurHandler);
        this.$element.on('$destroy', function () {
            _this.masterElement.removeEventListener('input', inputHandler);
            _this.masterElement.removeEventListener('blur', blurHandler);
        });
    };
    IsSameValidatorController.prototype.invalidHandler = function () {
        if (this.myEl.validity.valueMissing) {
            this.myEl.setCustomValidity(this.emptyMessage);
        }
        else if (this.myEl.value !== this.masterElement.value) {
            this.myEl.setCustomValidity(this.invalidMessage);
        }
        else {
            this.myEl.setCustomValidity('');
        }
    };
    IsSameValidatorController.$inject = ['$element', '$i18next'];
    return IsSameValidatorController;
}(nwfValidator_1.default));
exports.IsSameValidatorController = IsSameValidatorController;
var IsSameValidator = /** @class */ (function () {
    function IsSameValidator() {
        this.bindToController = {
            isSame: '@',
            emptyMessage: '@?',
            invalidMessage: '@?'
        };
        this.restrict = 'A';
        this.controller = IsSameValidatorController;
    }
    IsSameValidator.NAME = 'isSame';
    return IsSameValidator;
}());
exports.IsSameValidator = IsSameValidator;
// export factory function
function IsSameValidatorFactory() {
    return new IsSameValidator();
}
exports.IsSameValidatorFactory = IsSameValidatorFactory;
//# sourceMappingURL=isSame-directive.js.map