"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var lodash_es_1 = require("lodash-es");
var ColumnChooserController = /** @class */ (function () {
    function ColumnChooserController() {
        this.changesInFlight = false;
        this.popoverPlacement = 'auto bottom-left';
        this.isPopoverOpen = false;
        this.isInvalid = false;
    }
    ColumnChooserController.prototype.$onChanges = function (_a) {
        var options = _a.options;
        var newOptions = options ? options.currentValue : null;
        //we get initialized async and come in empty
        if (newOptions) {
            // I set my private options property to a copy of the incoming.
            this._options = this.cloneMyObj(newOptions);
            //Select the first option by default
            this.option = this._options[0];
            //now set selections 
            this.setSelections();
            //the actually sets it on the gridApi to reflect the change
            this.gridApi.columnDefs = this.cloneMyObj(this._selections);
            //update my ui (selecting / deselecting) based on the model I have set.
            this.refresh();
        }
    };
    ColumnChooserController.prototype.refresh = function () {
        var _this = this;
        // find the selected from the options
        var initialIdsToSpliceFrom = [];
        lodash_es_1.forEach(this._selections, function (selectionToRemoveFromOptions) {
            if (selectionToRemoveFromOptions && selectionToRemoveFromOptions.field) {
                var selIndex = lodash_es_1.findIndex(_this._options, { field: selectionToRemoveFromOptions.field });
                var cloneOfSelection = _this.cloneMyObj(selectionToRemoveFromOptions);
                initialIdsToSpliceFrom.push(selectionToRemoveFromOptions.field);
            }
        });
        // now splice them out of the options
        lodash_es_1.forEach(initialIdsToSpliceFrom, function (index) {
            var selIndex = lodash_es_1.findIndex(_this._options, { field: index });
            _this._options.splice(selIndex, 1);
        });
    };
    ColumnChooserController.prototype.closePopover = function () {
        this.isPopoverOpen = false;
    };
    ColumnChooserController.prototype.togglePopover = function () {
        //I take a snapshot when we open for use when I cancel()
        // logic is, if I am opening (from closed) and I don't have changes in Flight, I snapshot it.
        if (!this.isPopoverOpen && this.changesInFlight == false) {
            this._selectionsBeforeChange = this.cloneMyObj(this._selections);
            this._optionsBeforeChange = this.cloneMyObj(this._options);
        }
    };
    ColumnChooserController.prototype.setSelections = function () {
        var _this = this;
        if (!this.ngModel) {
            //we are implicitly "all" if we are blank or undefined.
            this._selections = this.cloneMyObj(this._options);
        }
        else {
            //when I set my options, I can set my selections based on my bound ngModel.
            var ngModelArr_1 = this.ngModel.split(',').map(function (sel) {
                var opt = lodash_es_1.find(_this.options, { field: sel });
                return opt;
            });
            var selectionsOrderedByNgModel = lodash_es_1.sortBy(ngModelArr_1, function (sel) { return ngModelArr_1.indexOf(sel.field); });
            this._selections = this.cloneMyObj(selectionsOrderedByNgModel);
        }
    };
    ColumnChooserController.prototype.toggleSelection = function (selection) {
        var isSel = selection.isSelected || null;
        if (!isSel) {
            this.selectOption(selection);
        }
        else {
            this.deSelectOption(selection);
        }
    };
    ColumnChooserController.prototype.deSelectOption = function (selIn) {
        delete selIn.isSelected;
    };
    ColumnChooserController.prototype.selectOption = function (selIn) {
        selIn.isSelected = true;
    };
    ColumnChooserController.prototype.deSelectOptions = function () {
        //Deselect means I am taking a selected column and moving it to available the [ < ]
        /* Now put slice myself from selections */
        var selectedOptions = lodash_es_1.filter(this._selections, { isSelected: true });
        [].splice.apply(this._options, [this._options.length, 0].concat(selectedOptions));
        /* Now remove from the selections */
        lodash_es_1.remove(this._selections, { isSelected: true });
        this.deSelectAllOptions(this._options);
        // flip my bit on changesInFlight to let cancel know what to do.
        this.changesInFlight = true;
        //validate.
        this.validate();
    };
    ColumnChooserController.prototype.deSelectAllOptions = function (options) {
        var _this = this;
        lodash_es_1.forEach(options, function (selOption) {
            _this.deSelectOption(selOption);
        });
    };
    ColumnChooserController.prototype.selectOptions = function () {
        /* Find my self in the schema options so I Can be put back where I belong */
        var selectedOptions = lodash_es_1.filter(this._options, { isSelected: true });
        [].splice.apply(this._selections, [this._selections.length, 0].concat(selectedOptions));
        /* Now remove from the selections */
        lodash_es_1.remove(this._options, { isSelected: true });
        this.deSelectAllOptions(this._selections);
        // flip my bit on changesInFlight to let cancel know what to do.
        this.changesInFlight = true;
        //validate.
        this.validate();
    };
    ColumnChooserController.prototype.moveSelection = function (fromIndex, toIndex) {
        var sels = this._selections;
        var element = sels[fromIndex];
        if (fromIndex === 0 && toIndex === -1) {
            return;
        }
        sels.splice(fromIndex, 1);
        sels.splice(toIndex, 0, element);
        // flip my bit on changesInFlight to let cancel know what to do.
        this.changesInFlight = true;
    };
    ColumnChooserController.prototype.moveSelectionsUp = function () {
        var _this = this;
        var selectedOptions = lodash_es_1.filter(this._selections, { isSelected: true });
        lodash_es_1.forEach(selectedOptions, function (optionToMove) {
            var idx = lodash_es_1.findIndex(_this._selections, { field: optionToMove.field });
            if (idx > 0) {
                _this.moveSelection(idx, idx - 1);
            }
        });
    };
    ColumnChooserController.prototype.moveSelectionsDown = function () {
        var _this = this;
        var selectedOptions = lodash_es_1.filter(this._selections, { isSelected: true }).reverse();
        lodash_es_1.forEach(selectedOptions, function (optionToMove) {
            var idx = lodash_es_1.findIndex(_this._selections, { field: optionToMove.field });
            if (idx < _this._selections.length - 1) {
                _this.moveSelection(idx, idx + 1);
            }
        });
    };
    ColumnChooserController.prototype.cloneMyObj = function (obj) {
        return JSON.parse(JSON.stringify(obj));
    };
    ColumnChooserController.prototype.resetColumns = function () {
        //Set my selections back to the original set of options when I was born (from the model)
        this._options = this.cloneMyObj(this.options);
        //Select the first option by default
        this.option = this._options[0];
        this.ngModel = this.defaultSelections;
        this.setSelections();
        this.refresh();
        this.validate();
        this.apply();
    };
    ColumnChooserController.prototype.cancel = function () {
        // if I have made any changes, I reset them to the snapshotted copy.
        if (this.changesInFlight) {
            this._selections = this._selectionsBeforeChange;
            this._options = this._optionsBeforeChange;
        }
        this.closePopover();
        this.changesInFlight = false;
        this.validate();
    };
    ColumnChooserController.prototype.apply = function () {
        this.gridApi.columnDefs = this.cloneMyObj(this._selections);
        var selectedFields = lodash_es_1.map(this._selections, 'field');
        this.closePopover();
        this.deSelectAllOptions(this._selections);
        this.deSelectAllOptions(this._options);
        this.changesInFlight = false;
        //if I have an paramsCtrl, I want to bind my columns param to my value
        if (this.paramsCtrl) {
            this.paramsCtrl.params.columns = selectedFields.join(',') || null;
        }
    };
    ColumnChooserController.prototype.validate = function () {
        this.isInvalid = false;
        if (this._selections.length === 0) {
            this.isInvalid = true;
        }
    };
    ;
    return ColumnChooserController;
}());
exports.default = ColumnChooserController;
//# sourceMappingURL=columnChooser-controller.js.map