"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var angular = require("angular");
var filterWidget_model_1 = require("./filterWidget-model");
var FilterWidgetController = /** @class */ (function () {
    function FilterWidgetController($scope) {
        var _this = this;
        this.isPopoverOpen = false;
        this.globalReset = false;
        /**
         * Watch on the params coming into directive that populates filter widget.
         * Watch is used since params are coming from ASYNC call.
         */
        $scope.$watch(function () { return _this.params; }, function (newVal, oldVal) {
            //we check if the model is already set.
            var hasModel = _this.model;
            //get json format for newVal.
            var newValJson = newVal ? angular.toJson(newVal) : '';
            //get json format for oldVal
            var oldValJson = oldVal ? angular.toJson(oldVal) : '';
            //set isReset=true if we have different json objects coming.
            var isReset = (newValJson != oldValJson);
            //if globalReset=true, then we don't about comparison and just set isReset=true;
            if (_this.globalReset) {
                isReset = true;
            }
            //we set a new model only when we have a newVal, AND, (newVal != oldVal)i.e. newParams are coming,
            // OR model is not defined.(params received first time)
            if (newVal && (isReset || !hasModel)) {
                _this.setModel(newVal);
            }
            //apply filter criteria if we have model and appliedFilters.
            if (_this.model && _this.appliedFilters) {
                _this.model.createAppliedCriteria(_this.appliedFilters);
            }
        });
        $scope.$watch(function () { return _this.appliedFilters; }, function (newVal, oldVal) {
            //get json format for newVal.
            var newValJson = newVal ? angular.toJson(newVal) : '';
            //get json format for oldVal
            var oldValJson = oldVal ? angular.toJson(oldVal) : '';
            //set isReset=true if we have different json objects coming.
            var isReset = (newValJson != oldValJson);
            // httpete did this to allow setting of an empty value to mean the same as an empty array.
            if (newVal == '') {
                newVal = [];
            }
            if (newVal && isReset && _this.model) {
                //creating an applied criteria.
                _this.model.createAppliedCriteria(newVal);
            }
        });
        //globalReset is used for cases when newVal, oldVal params are same, but still we want to reset the filter.
        //Special case, hence handled by an event.
        $scope.$on('resetFilterWidget', function (event, value) {
            _this.globalReset = true;
        });
    }
    FilterWidgetController.prototype.setCriterionValue = function (criterion, value) {
        criterion.value = value;
    };
    //sets the model to populate filter widget.
    FilterWidgetController.prototype.setModel = function (newVal) {
        // creating a new model as soon as we have a set of params.
        this.model = new filterWidget_model_1.default(newVal);
        this.model.generateNewCriteria();
        // Creating the shallow copy of params that will be used to drive the logic of filter widget and the template.
        // We are creating a shallow copy of the passed-in params,so that we only change the params used to drive the logic when passed-in params have "really" changed.
        // Hitting "Refresh" button does not change the params, it just gives us another copy. Thus, filter state is not preserved on the template. and model does not match up.
        // Having a separate copy will ensure we have one copy of params used in filter widget until we do a  "Browser refresh", or passed-in params have "really" changed.
        this.filterParams = [];
        this.filterParams = angular.extend({}, this.filterParams, newVal);
    };
    /**
     * @description returns the current array of criterion
     * @returns {Array}
     */
    FilterWidgetController.prototype.getCriteria = function () {
        if (this.model) {
            return this.model.getCriteria();
        }
        else {
            return [];
        }
    };
    /**
     * @description adds a new default criterion on click of "Add Filter" button
     */
    FilterWidgetController.prototype.addCriterion = function () {
        this.model.addCriterion();
    };
    /**
     * @description deletes a criterion from current criterion, else deletes all the applied criterion. Invoked on clicking Trash icon.
     * @param id
     */
    FilterWidgetController.prototype.deleteCriterion = function (criterion) {
        if (this.model.getCriteria().length > 1) {
            this.model.deleteCriterion(criterion);
        }
        else {
            this.deleteAppliedCriteria();
        }
    };
    /**
     * @description deletes all the criterion.
     */
    FilterWidgetController.prototype.deleteAppliedCriteria = function () {
        //deleting the applied criteria
        this.model.deleteAppliedCriteria();
        //setting the filters to empty.
        this.apply();
        //Adds the first criteria as default.
        this.model.generateNewCriteria();
        //reset all the selections in multi-select widget, criterion on date-time picker.
        this.model.params.filter(function (paramObject) {
            return paramObject.type === 'enum-multiple';
        }).map(function (paramObject) {
            paramObject.options.forEach(function (element) {
                element.selected = false;
            });
        });
    };
    /**
     * @description applies the filter grid params on hitting Apply button.
     */
    FilterWidgetController.prototype.apply = function () {
        this.model.apply();
        // fetching reference to grid params and updating them with new filters.
        var current = this.paramsCtrl.params;
        current.filter = this.createFilterParams();
        current.offset = 0;
        //closing the popover.
        this.isPopoverOpen = false;
    };
    /**
     * @description creates and then returns an array of comma separated criterion to be sent to filter grid params.
     * Iterates over applied Criteria since they contain all the applied criterion.
     * @returns {Array}
     */
    FilterWidgetController.prototype.createFilterParams = function () {
        var filters = [];
        for (var idx = 0; idx < this.model.appliedCriteria.length; idx++) {
            var criterion = this.model.appliedCriteria[idx];
            filters.push(criterion.property.id + ',' + criterion.operator.value + ',' + criterion.value);
        }
        return filters;
    };
    /**
     * @description cancel on hitting 'Cancel' button.
     */
    FilterWidgetController.prototype.cancel = function () {
        this.model.cancel();
        //closing the popover.
        this.isPopoverOpen = false;
    };
    /**
     * @description  method that return the options from filter config bundle based on the type passed, returns an object containing inputType and options.
     * @param paramType
     * @returns {Object}
     */
    FilterWidgetController.prototype.getOperatorOptions = function (paramType) {
        return this.model.getOperatorOptions(paramType);
    };
    /**
     * @description generates the dropdown options for operators based on property selected.
     * @param id
     */
    FilterWidgetController.prototype.updateCriterion = function (criterion) {
        this.model.updateCriterion(criterion);
    };
    /**
     * @description returns the number of the applied criteria (count for number of filters applied).
     * @returns {*}
     */
    FilterWidgetController.prototype.getNumberOfAppliedFilters = function () {
        if (this.model && this.model.appliedCriteria) {
            return this.model.appliedCriteria.length;
        }
        else {
            return 0;
        }
    };
    FilterWidgetController.$inject = ['$scope'];
    return FilterWidgetController;
}());
exports.default = FilterWidgetController;
//# sourceMappingURL=filterWidget-controller.js.map