/**
 * @ngdoc directive
 * @name grid footer directive
 * @description This is the implementation of grid footer directive
 * This directive is part of the the grid-footer component
 * which contains selected rows count and the paginator component.
 * @param {totalRecords} number of total records to be handled by paginator.
 * @param {title} string to be shown in the paginator.
 * @param {selectedRowsCount} number of selected rows from the grid
 * @example <nwf-grid-footer total-records=22 title="Nodes" selected-rows-count=2></nwf-grid-footer>
 *
 */
export declare class GridFooterComponent {
    static NAME: string;
    bindings: {
        totalRecords: string;
        title: string;
        titlePlural: string;
        selectedRowsCount: string;
        offset: string;
        usePagination: string;
        limit: string;
    };
    transclude: boolean;
    template: string;
    controller: {
        new (): {
            totalRecords: string;
            selectedRowsCount: any;
            isSelectionEnabled: boolean;
            usePagination: boolean;
            numPages: number;
            currentPage: number;
            offset: number;
            limit: number;
            onChange(): void;
            hasRecords(): boolean;
            $onInit(): void;
            $onChanges(changes: any): void;
        };
    };
}
