"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var gridMessageTemplate = require("./gridMessage-template.html");
var GridMessageController = /** @class */ (function () {
    function GridMessageController($scope) {
        this.$scope = $scope;
    }
    GridMessageController.$inject = ['$scope'];
    return GridMessageController;
}());
exports.GridMessageController = GridMessageController;
/**
 * @ngdoc directive
 * @name gridMessage directive
 * @description This is the implementation of gridMessage directive.
 * This directive provides a no-data-message template positioned on top of grid if there is no data present in the grid.
 * @param {message} string to be shown in the div template.
 * @example <nwf-grid-message message="No records found"></nwf-grid-message>
 */
var GridMessage = /** @class */ (function () {
    function GridMessage() {
        this.restrict = 'E';
        this.scope = {
            message: '@'
        };
        this.replace = true;
        this.template = gridMessageTemplate;
        this.bindToController = true;
        this.controllerAs = 'gridMessage';
        this.controller = GridMessageController;
    }
    GridMessage.NAME = 'nwfGridMessage';
    return GridMessage;
}());
exports.GridMessage = GridMessage;
// export factory function
function GridMessageFactory() {
    return new GridMessage();
}
exports.GridMessageFactory = GridMessageFactory;
//# sourceMappingURL=gridMessage-directive.js.map