"use strict";
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
var ng = require("angular");
var uiGrid = require("angular-ui-grid");
var columnChooser_component_1 = require("./components/column-chooser/columnChooser-component");
var export_component_1 = require("./components/export/export-component");
var filterWidget_directive_1 = require("./components/filter-widget/filterWidget-directive");
var filterWidget_module_1 = require("./components/filter-widget/filterWidget-module");
var gridFooter_component_1 = require("./components/grid-footer/gridFooter-component");
var gridMessage_directive_1 = require("./components/grid-message/gridMessage-directive");
var search_component_1 = require("./components/search/search-component");
var selection_component_1 = require("./components/selection/selection-component");
var gridParamController_component_1 = require("./gridParamController-component");
var GridModule = /** @class */ (function () {
    function GridModule() {
        this.native = ng.module(GridModule.NAME, GridModule.DEPENDENCIES);
        /* This is used in the template below */
        this.native.controller('nwfjsUiGridRowHiliter', ['$scope', function ($scope) {
                $scope.hilightrow = function (row) {
                    row.isHov = true;
                    this.grid.rows.forEach(function (r) {
                        if (r !== row) {
                            r.isHov = false;
                        }
                    });
                };
            }]);
        this.native.run(['$templateCache', function ($templateCache) {
                $templateCache.put('ui-grid/selectionRowHeaderButtons', "\n                <div class=\"ui-grid-selection-row-header-buttons\" ng-class=\"{'ui-grid-row-selected': row.isSelected}\">\n                    <div ng-if=\"row.grid.options.multiSelect\" class=\"custom-control custom-checkbox\">\n                    <input type=\"checkbox\" id=\"{{row.uid}}\" class=\"custom-control-input\" ng-checked=\"row.isSelected\" ng-click=\"selectButtonClick(row, $event)\">\n                    <label class=\"custom-control-label\" for=\"{{row.uid}}\"></label>\n                    </div>\n                    <div ng-if=\"!row.grid.options.multiSelect\" class=\"custom-control custom-radio\">\n                        <input type=\"radio\" id=\"{{row.uid}}\" class=\"custom-control-input\" ng-checked=\"row.isSelected\" ng-click=\"selectButtonClick(row, $event)\" name=\"uigrid-radios\">\n                        <label class=\"custom-control-label\" for=\"{{row.uid}}\"></label>\n                    </div>\n                </div>\n                ");
                /* line 64 -68 is our custom addition */
                $templateCache.put('ui-grid/uiGridViewport', "\n                <div\n                role=\"rowgroup\"\n                class=\"ui-grid-viewport\"\n                ng-style=\"colContainer.getViewportStyle()\"><!-- tbody -->\n                <div\n                  class=\"ui-grid-canvas\">\n                  <div\n                    ng-repeat=\"(rowRenderIndex, row) in rowContainer.renderedRows track by $index\"\n                    class=\"ui-grid-row\"\n\n                    ng-controller=\"nwfjsUiGridRowHiliter\"\n                    ng-mouseenter=\"hilightrow(row)\"\n                    ng-class=\"{ 'is-hovered': row.isHov }\"\n\n                    ng-style=\"Viewport.rowStyle(rowRenderIndex)\">\n                    <div\n                      role=\"row\"\n                      ui-grid-row=\"row\"\n                      row-render-index=\"rowRenderIndex\">\n                    </div>\n                  </div>\n                </div>\n              </div>\n                ");
                /* Custom override for luci pagination on top of uib-pagination - must be specified in template-url param */
                $templateCache.put("nwfjs/uib-pagination.html", "<li role=\"menuitem\" ng-if=\"::boundaryLinks\" ng-class=\"{disabled: noPrevious()||ngDisabled}\" class=\"pagination-first\"><button class=\"btn btn-icon btn-link\" href ng-click=\"selectPage(1, $event)\" ng-disabled=\"noPrevious()||ngDisabled\" uib-tabindex-toggle>{{::getText('first')}}</button></li>\n" +
                    "<li role=\"menuitem\" ng-if=\"::directionLinks\" ng-class=\"{disabled: noPrevious()||ngDisabled}\" class=\"pagination-prev\"><button class=\"btn btn-icon btn-link\" href ng-click=\"selectPage(page - 1, $event)\" ng-disabled=\"noPrevious()||ngDisabled\" uib-tabindex-toggle><nwf-icon icon-class=\"icon-misc-chevronleft\"></nwf-icon> {{::getText('previous')}}</button></li>\n" +
                    "<li role=\"menuitem\" ng-repeat=\"page in pages track by $index\" ng-class=\"{active: page.active,disabled: ngDisabled&&!page.active}\" class=\"pagination-page\"><button class=\"btn btn-icon btn-link\" href ng-click=\"selectPage(page.number, $event)\" ng-disabled=\"ngDisabled&&!page.active\" uib-tabindex-toggle>{{page.text}}</button></li>\n" +
                    "<li role=\"menuitem\" ng-if=\"::directionLinks\" ng-class=\"{disabled: noNext()||ngDisabled}\" class=\"pagination-next\"><button class=\"btn btn-icon btn-link\" href ng-click=\"selectPage(page + 1, $event)\" ng-disabled=\"noNext()||ngDisabled\" uib-tabindex-toggle>{{::getText('next')}} <nwf-icon icon-class=\"icon-misc-chevronright\"></nwf-icon></button></li>\n" +
                    "<li role=\"menuitem\" ng-if=\"::boundaryLinks\" ng-class=\"{disabled: noNext()||ngDisabled}\" class=\"pagination-last\"><button class=\"btn btn-icon btn-link\" href ng-click=\"selectPage(totalPages, $event)\" ng-disabled=\"noNext()||ngDisabled\" uib-tabindex-toggle>{{::getText('last')}}</button></li>\n" +
                    "");
            }]);
        this.native.component(gridParamController_component_1.GridParamsController.NAME, new gridParamController_component_1.GridParamsController());
        this.native.component(gridFooter_component_1.GridFooterComponent.NAME, new gridFooter_component_1.GridFooterComponent());
        this.native.component(columnChooser_component_1.default.NAME, new columnChooser_component_1.default());
        this.native.component(search_component_1.default.NAME, new search_component_1.default());
        this.native.directive(gridMessage_directive_1.GridMessage.NAME, gridMessage_directive_1.GridMessageFactory);
        this.native.component(filterWidget_directive_1.FilterWidget.NAME, new filterWidget_directive_1.FilterWidget());
        this.native.component(export_component_1.NwfGridExport.NAME, new export_component_1.NwfGridExport());
        this.native.component(selection_component_1.NwfGridSelection.NAME, new selection_component_1.NwfGridSelection());
        //we over-write bootstrap paginations behavior,
        //to always go to page=1, when page count changes instead of going to last page.
        this.native.config(['$provide', function ($provide) {
                $provide.decorator('uibPaging', ['$delegate', function ($delegate) {
                        //create a reference called as 'createFunc', of the 'create' method on uibPaging service.
                        var createFunc = $delegate.create;
                        //over-write 'create' method of original service with new implmentation.
                        $delegate.create = function (ctrl, $scope, $attrs) {
                            //'arguments' will have all possible arguments.
                            //'apply' attaches 'createFunc' to 'this' scope and then runs createFunc and return the result, 
                            //just as-if 'createFunc' is part of 'this' object scope
                            var applied = createFunc.apply(this, arguments);
                            //over-writing the updatePage method with our custom business logic.
                            ctrl.updatePage = function () {
                                ctrl.setNumPages($scope.$parent, $scope.totalPages); // Readonly variable
                                if ($scope.page > $scope.totalPages) {
                                    //over-written from original booststrap behavior.
                                    //we go to page=1 whenever this happens.
                                    $scope.selectPage(1);
                                }
                                else {
                                    ctrl.ngModelCtrl.$render();
                                }
                            };
                            //value returned by calling the original 'create' function against this functions scope.
                            //this also contains the updated implementation of updatePage.
                            return applied;
                        };
                        //return the handle to the uibPaging service back to the module.
                        return $delegate;
                    }]);
            }]);
    }
    GridModule.NAME = 'nwfGridModule';
    GridModule.DEPENDENCIES = [uiGrid, 'ui.grid.selection', 'ui.grid.resizeColumns', 'ui.grid.pagination', 'ui.grid.autoResize', filterWidget_module_1.default.NAME];
    return GridModule;
}());
exports.default = GridModule;
/* UiGrid Helpers and Options */
exports.UiGridDefaultOptions = {
    enableColumnMenus: false,
    rowHeight: 43,
    enableSelectionBatchEvent: false,
    enablePaginationControls: false,
    multiSelect: true
};
exports.UiGridServerSideDefaultOptions = {
    useExternalSorting: true,
    useExternalFiltering: true,
    enableFiltering: false
};
__export(require("./grid-rowSelectionMethod"));
__export(require("./grid-sortMethod"));
__export(require("./helpers/clientSide-helpers"));
//# sourceMappingURL=grid-module.js.map