"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var lodash_es_1 = require("lodash-es");
function UiGridRowSelectionMethod(item, isSelected, selectedItems, uniqueKey) {
    var index = selectedItems ? findIndexOfItem(selectedItems, item, uniqueKey) : -1;
    //If row is selected and does NOT exist in the selectedItems, add the row in selectedItems.
    if (index === -1 && isSelected) {
        selectedItems.push(item);
    }
    //If row is selected and exist in the selectedItems, do nothing.
    if (index !== -1 && isSelected) {
    } //do nothing.
    //If row is NOT selected and exist in the selectedItems. Remove that row from SelectedItems.
    //This is case for deselecting a row.
    if (index !== -1 && !isSelected) {
        removeSelectedItem(selectedItems, index);
    }
    //If row is NOT selected and does NOT exist in the selectedItems, do nothing.
    if (index === -1 && !isSelected) {
    } //do nothing.
}
exports.UiGridRowSelectionMethod = UiGridRowSelectionMethod;
function findIndexOfItem(selectedItems, item, uniqueKey) {
    var index;
    if (typeof item === 'object' && uniqueKey) {
        index = lodash_es_1.findIndex(selectedItems, [uniqueKey, item[uniqueKey]]);
    }
    else {
        index = selectedItems.indexOf(item);
    }
    return index;
}
exports.findIndexOfItem = findIndexOfItem;
function removeSelectedItem(selectedItems, indexToBeRemoved) {
    selectedItems.splice(indexToBeRemoved, 1);
}
exports.removeSelectedItem = removeSelectedItem;
//# sourceMappingURL=grid-rowSelectionMethod.js.map