"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UiGridClientDefaultOptions = {
    enableFiltering: true,
    paginationPageSize: 20
};
/**
 * @ngdoc function
 * @name gridClientPagination
 * @description method to implement client side PAGINATION for grid.
 */
function UiGridClientPagination(oldOffset, newOffset, gridAPI) {
    var totalPages = gridAPI.pagination.getTotalPages();
    if (newOffset === 0) {
        gridAPI.pagination.seek(1);
    }
    else if (newOffset === (totalPages - 1) * gridAPI.grid.options.paginationPageSize) {
        gridAPI.pagination.seek(totalPages);
    }
    else if (newOffset < oldOffset) {
        gridAPI.pagination.previousPage();
    }
    else if (newOffset > oldOffset) {
        gridAPI.pagination.nextPage();
    }
}
exports.UiGridClientPagination = UiGridClientPagination;
/**
 * @ngdoc function
 * @name clientFilter
 * @description client side FILTERING for grid.
 */
function UiGridClientFilter(gridAPI, uiGridConstants, rowSearcher, filter) {
    function getNumberValue(number) {
        return number % 1 == 0 ? parseInt(number) : parseFloat(number);
    }
    var conditionObject = {
        'gt': uiGridConstants.filter.GREATER_THAN,
        'lt': uiGridConstants.filter.LESS_THAN,
        'ct': uiGridConstants.filter.CONTAINS,
        'sw': uiGridConstants.filter.STARTS_WITH,
        'is': uiGridConstants.filter.EXACT,
        'nis': uiGridConstants.filter.NOT_EQUAL,
        'gte': uiGridConstants.filter.GREATER_THAN,
        'lte': uiGridConstants.filter.LESS_THAN,
    };
    //Finding all filters to be applied.
    var appliedFilters = [];
    for (var i = 0; i < filter.length; i++) {
        //Splitting each filter values.
        var filterParam = filter[i].split(',');
        //creating new filter object.
        var filterName = filterParam[0], operator = filterParam[1], filterValue = filterParam[2];
        if (operator == 'gte' || operator == 'lte') {
            // Check if the provided value is a date time.
            var timestamp = Date.parse(filterValue);
            var isValidSingleDate = !isNaN(timestamp);
            appliedFilters.push({
                columnName: filterName,
                //if the input value is date time
                term: isValidSingleDate ? new Date(filterValue) : getNumberValue(filterValue),
                condition: conditionObject[operator]
            });
        }
        else if (operator == 'btw') {
            var _a = filterValue.split('~'), fromValue = _a[0], toValue = _a[1];
            var fromDateValue = Date.parse(fromValue);
            var toDateValue = Date.parse(toValue);
            var isValidDate = !isNaN(fromDateValue) && !isNaN(toDateValue);
            // Added the greater than and less then filter criteria.
            appliedFilters.push({
                columnName: filterName,
                //if the input value is date time
                term: isValidDate ? new Date(fromValue) : getNumberValue(fromValue),
                condition: uiGridConstants.filter.GREATER_THAN
            });
            appliedFilters.push({
                columnName: filterName,
                //if the input value is date time
                term: isValidDate ? new Date(toValue) : getNumberValue(toValue),
                condition: uiGridConstants.filter.LESS_THAN
            });
        }
        else if (operator == 'lst') {
            var _b = filterValue.split('_'), firstValue = _b[0], addTimeValue = _b[1];
            var addTime = addTimeValue.substring(0, addTimeValue.length - 1);
            var addTimeUnit = addTimeValue.substring(addTimeValue.length - 1);
            var timestamp = new Date();
            if (addTimeUnit == 'h') {
                timestamp.setHours(timestamp.getHours() - addTime);
            }
            else if (addTimeUnit == 'd') {
                timestamp.setHours(timestamp.getHours() - (24 * addTime));
            }
            appliedFilters.push({
                columnName: filterName,
                term: timestamp,
                condition: uiGridConstants.filter.GREATER_THAN
            });
        }
        else {
            appliedFilters.push({
                columnName: filterName,
                //if operator is '<' OR '>', run a parseInt of number entered, else just set value as-is
                term: ((operator === 'gt') || (operator === 'lt')) ? getNumberValue(filterValue) : filterValue,
                condition: conditionObject[operator]
            });
        }
    }
    // Finding reference to the grid columns.
    var cols = gridAPI.grid.columns;
    var filterSet = false;
    //Applying the filters to the columns.
    for (var c = 0; c < cols.length; c++) {
        //set flag to false initially.
        filterSet = false;
        //we set the filters to empty initially.
        cols[c].filters = [];
        //finding the column (by matching to columnName) that has the filter applied from 'appliedFilters' list;
        var columnWithFilter = appliedFilters.filter(function (eachFilter) {
            return eachFilter.columnName === cols[c].field;
        });
        if (columnWithFilter && columnWithFilter.length >= 1) {
            //we can have more than 1 filter applied on one column.
            for (var _i = 0, columnWithFilter_1 = columnWithFilter; _i < columnWithFilter_1.length; _i++) {
                var filter_1 = columnWithFilter_1[_i];
                //we add the filter to filter property of column.
                cols[c].filters.push({ term: filter_1.term, condition: filter_1.condition });
            }
        }
        else {
            // we set filters to empty to remove any existing filters.
            cols[c].filters = [];
        }
    }
    // Searching across all the rows and columns of the grid for applied filters.
    rowSearcher.search(gridAPI.grid, gridAPI.grid.rows, gridAPI.grid.columns);
    //refresh the grid.
    gridAPI.grid.refresh();
    // Returning the count of totalItems.
    return gridAPI.grid.options.totalItems;
}
exports.UiGridClientFilter = UiGridClientFilter;
/**
 * @ngdoc function
 * @name clientSearch
 * @description method to implement client side SEARCH for grid.
 */
function UiGridClientSearch(renderableRows, columns, newQuery) {
    //getting the regex of the query parameter.
    var matcher = new RegExp(newQuery);
    // if query is entered.
    if (newQuery) {
        // looping over each row.
        renderableRows.forEach(function (row) {
            var match = false;
            //starting from first column since we have selection as col=0.
            for (var col = 1; col < columns.length; col++) {
                if (typeof (row.entity[columns[col].field]) === 'string' && row.entity[columns[col].field].match(matcher)) {
                    match = true;
                }
            }
            if (!match) {
                // setting row visibility to false if it does not matches the query string.
                row.visible = false;
            }
        });
    }
    //returning the count of visible rows ie. returning the rows that satisfy the query string critieria.
    return renderableRows.filter(function (row) {
        return row.visible;
    }).length;
}
exports.UiGridClientSearch = UiGridClientSearch;
/**
 * @ngdoc function
 * @name set grid Column type
 * @description method to set type property on grid columns 'columnDef' that aids in sorting.
 */
function UiGridSetColumnType(columnType) {
    var type = 'string';
    switch (columnType) {
        case 'metric':
        case 'number':
            type = 'number';
            break;
        default:
            type = 'string';
            break;
    }
    return type;
}
exports.UiGridSetColumnType = UiGridSetColumnType;
//# sourceMappingURL=clientSide-helpers.js.map