"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var controllerFun = function ($element, $scope, nwfConfig, nwfHelpService, $compile) {
    var helpable = $element[0];
    var guid = $scope.guid;
    //just tack on the guid on the data-netapp-id
    var naid = 'data-netapp-id';
    var newNaid = 'nwf-help-guid-' + guid;
    if (guid) {
        helpable.setAttribute(naid, newNaid);
    }
    var showIcon = $scope.showIcon == "false" ? false : true;
    //Get the base context ID for the application.
    var baseContextId = nwfConfig.getHelpContext();
    helpable.setAttribute('launchUrl', baseContextId);
    var launcher = function (evt) {
        evt.stopPropagation();
        if (typeof (guid) != "undefined") {
            nwfHelpService.helpDirectiveWindow.fDisplayHelpWithNavigation(baseContextId, guid);
        }
        else {
            nwfHelpService.helpDirectiveWindow.fDisplayHelpContents();
        }
    };
    var makeHelpableLink = function () {
        helpable.classList.add('nwf-help-link');
        helpable.addEventListener('click', launcher);
    };
    if (showIcon) {
        var template = '<nwf-icon icon-class="icon-info-help" class="nwf-help"></nwf-icon>';
        var linkFn = $compile(template);
        var content = linkFn($scope);
        $element.append(content);
        var helpIcon = content[0];
        $scope.$watch('guid', function (newVal) {
            //just tack on the guid on the data-netapp-id
            var naid = 'data-netapp-id';
            var newNaid = 'nwf-help-icon-guid-' + newVal;
            helpIcon.setAttribute(naid, newNaid);
        });
        helpIcon.addEventListener('click', launcher);
        /* If I am a link, I want it to be clickable too */
        if (helpable.tagName == 'A') {
            makeHelpableLink();
        }
    }
    else {
        makeHelpableLink();
    }
    $element.on('$destroy', function () {
        helpable.removeEventListener('click', launcher);
    });
};
controllerFun.$inject = ["$element", "$scope", "nwfConfig", "nwfHelpService", "$compile"];
exports.default = controllerFun;
//# sourceMappingURL=nwfHelp-controller.js.map