"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Copyright (c) 2015 NetApp
 * All rights reserved
 *
 * @ngdoc directive
 * @name nwfHelp
 * @description
 * Help directive is used to provide context-sensitive help for applications using webworks.
 * This uses WWHAPI from webworks help JavaScript based APIs
 *
 * An application needs to provide base context for the help on its server by using nwfConfigProvider.
 * It can then continue to use the directive by passing in GUID for help within it's screens.
 * @example
 *
 *  nwfConfigProvider.setHelpContext('GUID-646AA4A1-ED85-48B1-9AD1-018D44F055B8');
 * <legend class="form-legend" nwf-help guid="GUID-CEA1F463-AE33-4054-8C5E-2A128DC5EF24">NTP Server</legend>
 */
var nwfHelp_controller_1 = require("./nwfHelp-controller");
var NwfHelp = /** @class */ (function () {
    function NwfHelp() {
        this.restrict = 'EA';
        this.scope = {
            guid: '@',
            showIcon: '@'
        };
        this.controller = nwfHelp_controller_1.default;
    }
    NwfHelp.NAME = 'nwfHelp';
    return NwfHelp;
}());
exports.NwfHelp = NwfHelp;
// export factory function
function NwfHelpFactory() {
    return new NwfHelp();
}
exports.NwfHelpFactory = NwfHelpFactory;
//# sourceMappingURL=nwfHelp-directive.js.map