"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var NwfLoadingIndicatorController = /** @class */ (function () {
    function NwfLoadingIndicatorController($element, $rootScope, nwfConfig, $scope, $timeout, $transitions) {
        var _this = this;
        this.$scope = $scope;
        this.$timeout = $timeout;
        this.$transitions = $transitions;
        this._hasOverlay = false;
        this.myElement = $element[0];
        this.hideCls = 'hide';
        this.showCls = 'show';
        /* Now I connect my internal controller Events bound to me */
        $rootScope.$on('loadingIndicator', this.showOrHide.bind(this));
        this.$transitions.onStart({}, function (transition) {
            _this.hide();
        });
        this._hasOverlay = nwfConfig.getLoadingIndicatorOverlay();
        //this makes sure we add classes for non-login pages.
        $rootScope.$on('nwfHideLogin', function () {
            if (_this._hasOverlay) {
                _this.myElement.classList.add('has-overlay');
            }
        });
        $rootScope.$on('nwfShowLogin', function () {
            _this.myElement.classList.remove('has-overlay');
        });
    }
    NwfLoadingIndicatorController.prototype.show = function (message) {
        var _this = this;
        /* Now I support setting a message */
        this.loadingMsg = message;
        this.$timeout(function () { return _this.$scope.$digest(); });
        this.myElement.classList.remove(this.hideCls);
    };
    NwfLoadingIndicatorController.prototype.hide = function () {
        this.loadingMsg = '';
        this.myElement.classList.add(this.hideCls);
    };
    NwfLoadingIndicatorController.prototype.showOrHide = function (thisObject, showOrHide, message) {
        if (showOrHide == this.showCls) {
            this.show(message);
        }
        else if (showOrHide == this.hideCls) {
            this.hide();
        }
        else {
            throw Error('You told the loadingIndicator to do something other than show or hide');
        }
    };
    NwfLoadingIndicatorController.$inject = ['$element', '$rootScope', 'nwfConfig', '$scope', '$timeout', '$transitions'];
    return NwfLoadingIndicatorController;
}());
exports.NwfLoadingIndicatorController = NwfLoadingIndicatorController;
var NwfLoadingIndicator = /** @class */ (function () {
    function NwfLoadingIndicator() {
        this.controller = NwfLoadingIndicatorController;
        this.template = "<div class=\"l-nwf-loading-spinner\" ng-class=\"$ctrl.loadingMsg ? 'has-msg': ''\"><div class=\"nwf-loading-spinner\"></div><div class=\"nwf-loading-msg\" ng-if=\"$ctrl.loadingMsg\">{{$ctrl.loadingMsg}}</div></div>";
    }
    NwfLoadingIndicator.NAME = 'nwfLoadingIndicator';
    return NwfLoadingIndicator;
}());
exports.default = NwfLoadingIndicator;
//# sourceMappingURL=loadingIndicator-component.js.map