"use strict";
/**
 * Configuration provider to set configuration data to NwfJS.
 * Every application will have its help context and can use the help directive by passing in screen specific GUID after that.
 */
Object.defineProperty(exports, "__esModule", { value: true });
function default_1() {
    var helpContext;
    var helpBasePath = "/OnCommand/help/netapp";
    //we dont show overlay background by default...
    var hasOverlay = false;
    return {
        setHelpContext: function (_helpCont) {
            helpContext = _helpCont;
        },
        setHelpBasePath: function (_basePath) {
            helpBasePath = _basePath;
        },
        loadingIndicatorOverlay: function (_hasOverlay) {
            hasOverlay = _hasOverlay;
        },
        $get: function () {
            return {
                getHelpContext: function () {
                    return helpContext;
                },
                getHelpBasePath: function () {
                    return helpBasePath;
                },
                getLoadingIndicatorOverlay: function () {
                    return hasOverlay;
                }
            };
        }
    };
}
exports.default = default_1;
//# sourceMappingURL=nwfConfig-provider.js.map