"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var angular = require("angular");
var NwfPageAlertController = /** @class */ (function () {
    function NwfPageAlertController($rootScope, $scope, $timeout, $element, $compile, $sce, $transitions) {
        this.$rootScope = $rootScope;
        this.$scope = $scope;
        this.$timeout = $timeout;
        this.$element = $element;
        this.$compile = $compile;
        this.$sce = $sce;
        this.$transitions = $transitions;
    }
    NwfPageAlertController.prototype.$onInit = function () {
        /* Now I connect my internal controller Events bound to me */
        this.$rootScope.$on("pageAlertShowMessage", this.showMessage.bind(this));
        this.$rootScope.$on("pageAlertHide", this.close.bind(this));
        this.setSeverity("ok");
        this.$element[0].classList.add("d-none");
    };
    // Set the icon and state class based on the given severity
    NwfPageAlertController.prototype.setSeverity = function (severity) {
        this.severity = severity;
        var stateClass, iconClass;
        if (severity == "critical") {
            stateClass = "is-critical";
            iconClass = "icon-status-critical";
        }
        else if (severity == "warning") {
            stateClass = "is-warning";
            iconClass = "icon-status-warning";
        }
        else if (severity == "ok") {
            stateClass = "is-ok";
            iconClass = "icon-status-ok-circlecheck";
        }
        else if (severity == "error") {
            stateClass = "is-error";
            iconClass = "icon-status-error-full";
        }
        else if (severity == "info") {
            stateClass = "is-info";
            iconClass = "icon-status-info";
        }
        else {
            //default to ok.
            stateClass = "is-ok";
            iconClass = "icon-status-ok-circlecheck";
        }
        this.stateClass = stateClass;
        this.iconClass = iconClass;
    };
    /* To call this outside me, use e.g. angular.element(document.body).scope().$emit('pageAlertShowMessage', 'My answer is this - nothing.', 'critical'); */
    NwfPageAlertController.prototype.showMessage = function (event, message, severity, fade) {
        var _this = this;
        this.message = message ? this.createMessageTemplate(message) : "";
        this.setSeverity(severity);
        this.$element[0].classList.remove("d-none");
        this.isShowing = "show";
        //Fade after timeout
        var fadeInt = null;
        if (fade) {
            fadeInt = Number.isInteger(fade) ? fade : 5000;
        }
        if (fadeInt) {
            this.$timeout(this.close.bind(this), fadeInt);
        }
        //I come down when transition happens
        this.stateChangeStartTransition = this.$transitions.onStart({}, function (transition) {
            _this.close();
        });
    };
    /* To call this outside me, use e.g. angular.element(document.body).scope().$emit('pageAlertHide'); */
    NwfPageAlertController.prototype.close = function () {
        this.$element[0].classList.add("d-none");
        this.isShowing = "";
        /* Now I de-register the listener for efficiency */
        if (angular.isFunction(this.stateChangeStartTransition)) {
            this.stateChangeStartTransition();
        }
    };
    //This method creates the message template.
    NwfPageAlertController.prototype.createMessageTemplate = function (message) {
        // First I test if the message has a valid html start and end tag, if not, I do it for them.
        var hasStartAndEndTag = message.charAt(0) === "<" && message.charAt(message.length) === ">";
        if (!hasStartAndEndTag) {
            message = "<span>" + message + "</span>";
        }
        var compiled = this.$compile(message)(this.$scope);
        return this.$sce.trustAsHtml(compiled.html());
    };
    NwfPageAlertController.$inject = ["$rootScope", "$scope", "$timeout", "$element", "$compile", "$sce", "$transitions"];
    return NwfPageAlertController;
}());
exports.default = NwfPageAlertController;
//# sourceMappingURL=nwfPageAlert.controller.js.map