"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var loginFailedModalTemplate = require("./nwfLogin-failed-dialog.html");
var loginForgotPasswordTemplate = require("./nwfLogin-forgot-password-info.html");
var loginResetPasswordResultTemplate = require("./nwfResetPasswordResult-modal.html");
var NwfLoginController = /** @class */ (function () {
    function NwfLoginController($uibModal, $rootScope, $element, authStrategy, $i18next, $scope) {
        this.$uibModal = $uibModal;
        this.$rootScope = $rootScope;
        this.$element = $element;
        this.authStrategy = authStrategy;
        this.$i18next = $i18next;
        this.isOemVendor = false;
        this.titleElement = null;
        this.username = null;
        this.password = null;
        //Forgot Password
        this.forgotPassword = false;
        //Reset Password
        this.resetPassword = false;
        this.authToken = null;
        this.resetPasswordMatch = true;
        // Controller used by login failed dialog.
        this.loginFailedController = ['$uibModalInstance',
            function ($uibModalInstance) {
                this.ok = function () {
                    $uibModalInstance.close();
                };
            }
        ];
        // Controller used by reset password modal instance on success. The user is redirected to login page.
        this.resetPasswordSuccessController = ['$uibModalInstance',
            function ($uibModalInstance) {
                this.ok = function () {
                    $uibModalInstance.close();
                    window.location.href = '/';
                };
            }
        ];
        $scope.$watchGroup(['homeHref', 'supportHref'], this.updateHrefs.bind(this));
    }
    NwfLoginController.prototype.updateHrefs = function () {
        var netappHome = 'http://netapp.com';
        if (!this.homeHref) {
            this.homeHref = netappHome;
        }
        if (!this.supportHref) {
            this.supportHref = 'http://mysupport.netapp.com';
        }
        this.isOemVendor = false;
        if (this.homeHref !== netappHome) {
            this.isOemVendor = true;
        }
    };
    /* onLoginForm Submit */
    NwfLoginController.prototype.submitFn = function () {
        var _this = this;
        this.inFlight = true;
        var credentials = {
            username: this.username,
            password: this.password
        };
        return this.authStrategy.authenticateFn(credentials).then(function () {
            _this.inFlight = false;
        }).catch(function (error) {
            var err = error && error.data ? error.data : null;
            if (err && err.status) {
                _this.errorCode = err.status || -1;
            }
            _this.inFlight = false;
            _this.$uibModal.open({
                template: loginFailedModalTemplate,
                controller: _this.loginFailedController,
                resolve: {
                    errorCode: function () { return _this.errorCode; }
                },
                controllerAs: '$ctrl',
                bindToController: true
            });
        });
    };
    //Function to toggle the scope variable.
    NwfLoginController.prototype.forgotPasswordToggleFn = function () {
        this.forgotPassword = (this.forgotPassword === false) ? true : false;
    };
    //Forgot Password cancel action.
    NwfLoginController.prototype.forgotPasswordCancelFn = function () {
        this.forgotPassword = false;
    };
    //forgot password on submit.
    NwfLoginController.prototype.forgotPasswordSubmitFn = function () {
        var _this = this;
        var credentials = {
            username: this.username
        };
        return this.authStrategy.forgotPasswordAuthenticateFn(credentials).then(function () {
            var forgotPasswordToggle = _this.$uibModal.open({
                template: loginForgotPasswordTemplate,
                controller: ['$scope', 'forgotPasswordName', function ($scope, forgotPasswordName) {
                        $scope.username = forgotPasswordName;
                    }],
                resolve: {
                    forgotPasswordName: function () {
                        return credentials.username;
                    }
                }
            });
            //Once done do back to the Login form.
            forgotPasswordToggle.result.then(function () {
                _this.forgotPasswordToggleFn();
            });
        });
    };
    //Reset password on cancel.
    NwfLoginController.prototype.resetPasswordCancelFn = function () {
        window.location.href = document.location.origin;
    };
    //Reset password on submit.
    NwfLoginController.prototype.resetPasswordSubmitFn = function () {
        var _this = this;
        var data = {
            user: this.username,
            newPassword: this.newPassword,
            confirmNewPassword: this.confirmNewPassword,
            auth_token: this.authToken
        };
        //Check if passwords match
        if (this.newPassword !== this.confirmNewPassword) {
            this.resetPasswordMatch = false;
            return;
        }
        else {
            this.resetPasswordMatch = true;
        }
        return this.authStrategy.resetPasswordFn(data).then(function () {
            _this.message = _this.$i18next.t("nwfjs:resetPasswordSucceed");
            _this.success = true;
            //Show the modal with success message from the server.
            _this.$uibModal.open({
                template: loginResetPasswordResultTemplate,
                controller: _this.resetPasswordSuccessController,
                resolve: {
                    success: function () { return _this.success; },
                    message: function () { return _this.message; }
                },
                controllerAs: '$ctrl',
                bindToController: true
            });
        }).catch(function (error) {
            error = error.data;
            _this.message = _this.$i18next.t("nwfjs:resetPasswordFailed");
            if (error.message) {
                _this.message = error.message;
            }
            if (error && error.status) {
                _this.errorCode = error.status || -1;
            }
            _this.success = false;
            //Show the  modal with failure message from the server.
            _this.$uibModal.open({
                template: loginResetPasswordResultTemplate,
                resolve: {
                    errorCode: function () { return _this.errorCode; },
                    message: function () { return _this.message; },
                    success: function () { return _this.success; }
                },
                controller: _this.loginFailedController,
                controllerAs: '$ctrl',
                bindToController: true
            });
        });
    };
    NwfLoginController.prototype.$onInit = function () {
        // If the server sends a username and auth_token, the only use case we have is that user has send a request to reset the password with this URL.
        // Set the boolean to reset password to be true.
        var authToken = 'auth_token';
        var search = document.location.search;
        if (search) {
            var split = search.split('?');
            var $stateParams = split[split.length - 1].split('&');
            var stateParams = {};
            $stateParams.forEach(function (item) {
                var pair = item.split('=');
                stateParams[pair[0]] = pair[1];
            });
            if (stateParams.user !== undefined && stateParams[authToken] !== undefined) {
                this.username = stateParams.user;
                this.resetPassword = true;
                this.forgotPassword = false;
                this.authToken = stateParams[authToken];
                this.$rootScope.$broadcast('nwfShowLogin');
            }
        }
    };
    NwfLoginController.prototype.$postLink = function () {
        var el = this.$element[0];
        var frm = el.querySelector('#nwf-login-form');
        var resetMyForm = function () {
            for (var i = 0; i < frm.elements.length; i++) {
                var h = 'hasBeenBlurred';
                if (frm.elements[i][h]) {
                    delete frm.elements[i][h];
                }
            }
        };
        /* When I hide, I want to reset my form (blowing out the values) and then reset the validation */
        this.$rootScope.$on('nwfHideLogin', function () { frm.reset(); });
        /*
        This is something I'm not happy with. When I reset, I need to flip the hasBeenBlurred bit so my nwfValidation works as if it has been reset
        it is rare that I have a reset case, and for now I just have this on the login form.
        */
        frm.addEventListener('reset', resetMyForm);
    };
    NwfLoginController.$inject = ['$uibModal', '$rootScope', '$element', 'authStrategy', '$i18next', '$scope'];
    return NwfLoginController;
}());
exports.default = NwfLoginController;
//# sourceMappingURL=nwfLogin-controller.js.map