"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var logoutFailedModalTemplate = require("./nwfLogout-failed-dialog.html");
var NwfLogoutController = /** @class */ (function () {
    function NwfLogoutController($scope, $uibModal, authStrategy) {
        // Controller used by logout failed dialog.
        var logoutFailedController = ['$scope', '$uibModalInstance',
            function ($scope, $uibModalInstance) {
                $scope.ok = function () {
                    $uibModalInstance.close();
                };
            }
        ];
        //Logout call.
        $scope.logoutFn = function (e) {
            e.preventDefault();
            authStrategy.logoutFn().then(function () {
                authStrategy.navigateToLoginPage(true);
            }).catch(function () {
                $uibModal.open({
                    template: logoutFailedModalTemplate,
                    controller: logoutFailedController,
                    windowClass: 'nwf-login-error-modal',
                    backdrop: 'static'
                });
            });
        };
    }
    NwfLogoutController.$inject = ['$scope', '$uibModal', 'authStrategy'];
    return NwfLogoutController;
}());
exports.default = NwfLogoutController;
//# sourceMappingURL=nwfLogout-controller.js.map