import * as tslib_1 from "tslib";
import { createEntityAdapter } from '@ngrx/entity';
import { defaultSelectId } from '../utils/utilities';
export function createEntityDefinition(metadata) {
    var entityName = metadata.entityName;
    if (!entityName) {
        throw new Error('Missing required entityName');
    }
    metadata.entityName = entityName = entityName.trim();
    var selectId = metadata.selectId || defaultSelectId;
    var sortComparer = (metadata.sortComparer = metadata.sortComparer || false);
    var entityAdapter = createEntityAdapter({ selectId: selectId, sortComparer: sortComparer });
    var entityDispatcherOptions = metadata.entityDispatcherOptions || {};
    var initialState = entityAdapter.getInitialState(tslib_1.__assign({ entityName: entityName, filter: '', loaded: false, loading: false, changeState: {} }, (metadata.additionalCollectionState || {})));
    var noChangeTracking = metadata.noChangeTracking === true; // false by default
    return {
        entityName: entityName,
        entityAdapter: entityAdapter,
        entityDispatcherOptions: entityDispatcherOptions,
        initialState: initialState,
        metadata: metadata,
        noChangeTracking: noChangeTracking,
        selectId: selectId,
        sortComparer: sortComparer,
    };
}
//# sourceMappingURL=data:application/json;base64,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