import * as tslib_1 from "tslib";
import { compose } from '@ngrx/store';
import { DEFAULT_EFFECT_CONFIG, } from './models';
import { getSourceForInstance } from './utils';
var METADATA_KEY = '__@ngrx/effects__';
export function Effect(config) {
    if (config === void 0) { config = {}; }
    return function (target, propertyName) {
        var metadata = tslib_1.__assign({}, DEFAULT_EFFECT_CONFIG, config, { // Overrides any defaults if values are provided
            propertyName: propertyName });
        addEffectMetadataEntry(target, metadata);
    };
}
export function getEffectDecoratorMetadata(instance) {
    var effectsDecorators = compose(getEffectMetadataEntries, getSourceForInstance)(instance);
    return effectsDecorators;
}
/**
 * Type guard to detemine whether METADATA_KEY is already present on the Class
 * constructor
 */
function hasMetadataEntries(sourceProto) {
    return sourceProto.constructor.hasOwnProperty(METADATA_KEY);
}
/** Add Effect Metadata to the Effect Class constructor under specific key */
function addEffectMetadataEntry(sourceProto, metadata) {
    if (hasMetadataEntries(sourceProto)) {
        sourceProto.constructor[METADATA_KEY].push(metadata);
    }
    else {
        Object.defineProperty(sourceProto.constructor, METADATA_KEY, {
            value: [metadata],
        });
    }
}
function getEffectMetadataEntries(sourceProto) {
    return hasMetadataEntries(sourceProto)
        ? sourceProto.constructor[METADATA_KEY]
        : [];
}
//# sourceMappingURL=data:application/json;base64,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