import { getCreateEffectMetadata } from './effect_creator';
import { getEffectDecoratorMetadata } from './effect_decorator';
export function getEffectsMetadata(instance) {
    return getSourceMetadata(instance).reduce(function (acc, _a) {
        var propertyName = _a.propertyName, dispatch = _a.dispatch, resubscribeOnError = _a.resubscribeOnError;
        acc[propertyName] = { dispatch: dispatch, resubscribeOnError: resubscribeOnError };
        return acc;
    }, {});
}
export function getSourceMetadata(instance) {
    var effects = [
        getEffectDecoratorMetadata,
        getCreateEffectMetadata,
    ];
    return effects.reduce(function (sources, source) { return sources.concat(source(instance)); }, []);
}
//# sourceMappingURL=data:application/json;base64,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