import * as tslib_1 from "tslib";
import { merge } from 'rxjs';
import { ignoreElements, map, materialize, catchError } from 'rxjs/operators';
import { getSourceMetadata } from './effects_metadata';
import { getSourceForInstance } from './utils';
export function mergeEffects(sourceInstance, errorHandler) {
    var sourceName = getSourceForInstance(sourceInstance).constructor.name;
    var observables$ = getSourceMetadata(sourceInstance).map(function (_a) {
        var propertyName = _a.propertyName, dispatch = _a.dispatch, resubscribeOnError = _a.resubscribeOnError;
        var observable$ = typeof sourceInstance[propertyName] === 'function'
            ? sourceInstance[propertyName]()
            : sourceInstance[propertyName];
        var resubscribable$ = resubscribeOnError
            ? resubscribeInCaseOfError(observable$, errorHandler)
            : observable$;
        if (dispatch === false) {
            return resubscribable$.pipe(ignoreElements());
        }
        var materialized$ = resubscribable$.pipe(materialize());
        return materialized$.pipe(map(function (notification) { return ({
            effect: sourceInstance[propertyName],
            notification: notification,
            propertyName: propertyName,
            sourceName: sourceName,
            sourceInstance: sourceInstance,
        }); }));
    });
    return merge.apply(void 0, tslib_1.__spread(observables$));
}
function resubscribeInCaseOfError(observable$, errorHandler) {
    return observable$.pipe(catchError(function (error) {
        if (errorHandler)
            errorHandler.handleError(error);
        // Return observable that produces this particular effect
        return resubscribeInCaseOfError(observable$, errorHandler);
    }));
}
//# sourceMappingURL=data:application/json;base64,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