/**
 * @license NgRx 8.6.0
 * (c) 2015-2018 Brandon Roberts, Mike Ryan, Rob Wormald, Victor Savkin
 * License: MIT
 */
(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('tslib'), require('@ngrx/store'), require('@angular/core')) :
    typeof define === 'function' && define.amd ? define('@ngrx/entity', ['exports', 'tslib', '@ngrx/store', '@angular/core'], factory) :
    (global = global || self, factory((global.ngrx = global.ngrx || {}, global.ngrx.entity = {}), global.tslib, global.ngrx.store, global.ng.core));
}(this, function (exports, tslib_1, store, core) { 'use strict';

    function getInitialEntityState() {
        return {
            ids: [],
            entities: {},
        };
    }
    function createInitialStateFactory() {
        function getInitialState(additionalState) {
            if (additionalState === void 0) { additionalState = {}; }
            return Object.assign(getInitialEntityState(), additionalState);
        }
        return { getInitialState: getInitialState };
    }

    function createSelectorsFactory() {
        function getSelectors(selectState) {
            var selectIds = function (state) { return state.ids; };
            var selectEntities = function (state) { return state.entities; };
            var selectAll = store.createSelector(selectIds, selectEntities, function (ids, entities) {
                return ids.map(function (id) { return entities[id]; });
            });
            var selectTotal = store.createSelector(selectIds, function (ids) { return ids.length; });
            if (!selectState) {
                return {
                    selectIds: selectIds,
                    selectEntities: selectEntities,
                    selectAll: selectAll,
                    selectTotal: selectTotal,
                };
            }
            return {
                selectIds: store.createSelector(selectState, selectIds),
                selectEntities: store.createSelector(selectState, selectEntities),
                selectAll: store.createSelector(selectState, selectAll),
                selectTotal: store.createSelector(selectState, selectTotal),
            };
        }
        return { getSelectors: getSelectors };
    }

    var DidMutate;
    (function (DidMutate) {
        DidMutate[DidMutate["EntitiesOnly"] = 0] = "EntitiesOnly";
        DidMutate[DidMutate["Both"] = 1] = "Both";
        DidMutate[DidMutate["None"] = 2] = "None";
    })(DidMutate || (DidMutate = {}));
    function createStateOperator(mutator) {
        return function operation(arg, state) {
            var clonedEntityState = {
                ids: tslib_1.__spread(state.ids),
                entities: tslib_1.__assign({}, state.entities),
            };
            var didMutate = mutator(arg, clonedEntityState);
            if (didMutate === DidMutate.Both) {
                return Object.assign({}, state, clonedEntityState);
            }
            if (didMutate === DidMutate.EntitiesOnly) {
                return tslib_1.__assign({}, state, { entities: clonedEntityState.entities });
            }
            return state;
        };
    }

    function selectIdValue(entity, selectId) {
        var key = selectId(entity);
        if (core.isDevMode() && key === undefined) {
            console.warn('@ngrx/entity: The entity passed to the `selectId` implementation returned undefined.', 'You should probably provide your own `selectId` implementation.', 'The entity that was passed:', entity, 'The `selectId` implementation:', selectId.toString());
        }
        return key;
    }

    function createUnsortedStateAdapter(selectId) {
        function addOneMutably(entity, state) {
            var key = selectIdValue(entity, selectId);
            if (key in state.entities) {
                return DidMutate.None;
            }
            state.ids.push(key);
            state.entities[key] = entity;
            return DidMutate.Both;
        }
        function addManyMutably(entities, state) {
            var e_1, _a;
            var didMutate = false;
            try {
                for (var entities_1 = tslib_1.__values(entities), entities_1_1 = entities_1.next(); !entities_1_1.done; entities_1_1 = entities_1.next()) {
                    var entity = entities_1_1.value;
                    didMutate = addOneMutably(entity, state) !== DidMutate.None || didMutate;
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (entities_1_1 && !entities_1_1.done && (_a = entities_1.return)) _a.call(entities_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return didMutate ? DidMutate.Both : DidMutate.None;
        }
        function addAllMutably(entities, state) {
            state.ids = [];
            state.entities = {};
            addManyMutably(entities, state);
            return DidMutate.Both;
        }
        function removeOneMutably(key, state) {
            return removeManyMutably([key], state);
        }
        function removeManyMutably(keysOrPredicate, state) {
            var keys = keysOrPredicate instanceof Array
                ? keysOrPredicate
                : state.ids.filter(function (key) { return keysOrPredicate(state.entities[key]); });
            var didMutate = keys
                .filter(function (key) { return key in state.entities; })
                .map(function (key) { return delete state.entities[key]; }).length > 0;
            if (didMutate) {
                state.ids = state.ids.filter(function (id) { return id in state.entities; });
            }
            return didMutate ? DidMutate.Both : DidMutate.None;
        }
        function removeAll(state) {
            return Object.assign({}, state, {
                ids: [],
                entities: {},
            });
        }
        function takeNewKey(keys, update, state) {
            var original = state.entities[update.id];
            var updated = Object.assign({}, original, update.changes);
            var newKey = selectIdValue(updated, selectId);
            var hasNewKey = newKey !== update.id;
            if (hasNewKey) {
                keys[update.id] = newKey;
                delete state.entities[update.id];
            }
            state.entities[newKey] = updated;
            return hasNewKey;
        }
        function updateOneMutably(update, state) {
            return updateManyMutably([update], state);
        }
        function updateManyMutably(updates, state) {
            var newKeys = {};
            updates = updates.filter(function (update) { return update.id in state.entities; });
            var didMutateEntities = updates.length > 0;
            if (didMutateEntities) {
                var didMutateIds = updates.filter(function (update) { return takeNewKey(newKeys, update, state); }).length > 0;
                if (didMutateIds) {
                    state.ids = state.ids.map(function (id) { return newKeys[id] || id; });
                    return DidMutate.Both;
                }
                else {
                    return DidMutate.EntitiesOnly;
                }
            }
            return DidMutate.None;
        }
        function mapMutably(map, state) {
            var changes = state.ids.reduce(function (changes, id) {
                var change = map(state.entities[id]);
                if (change !== state.entities[id]) {
                    changes.push({ id: id, changes: change });
                }
                return changes;
            }, []);
            var updates = changes.filter(function (_a) {
                var id = _a.id;
                return id in state.entities;
            });
            return updateManyMutably(updates, state);
        }
        function upsertOneMutably(entity, state) {
            return upsertManyMutably([entity], state);
        }
        function upsertManyMutably(entities, state) {
            var e_2, _a;
            var added = [];
            var updated = [];
            try {
                for (var entities_2 = tslib_1.__values(entities), entities_2_1 = entities_2.next(); !entities_2_1.done; entities_2_1 = entities_2.next()) {
                    var entity = entities_2_1.value;
                    var id = selectIdValue(entity, selectId);
                    if (id in state.entities) {
                        updated.push({ id: id, changes: entity });
                    }
                    else {
                        added.push(entity);
                    }
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (entities_2_1 && !entities_2_1.done && (_a = entities_2.return)) _a.call(entities_2);
                }
                finally { if (e_2) throw e_2.error; }
            }
            var didMutateByUpdated = updateManyMutably(updated, state);
            var didMutateByAdded = addManyMutably(added, state);
            switch (true) {
                case didMutateByAdded === DidMutate.None &&
                    didMutateByUpdated === DidMutate.None:
                    return DidMutate.None;
                case didMutateByAdded === DidMutate.Both ||
                    didMutateByUpdated === DidMutate.Both:
                    return DidMutate.Both;
                default:
                    return DidMutate.EntitiesOnly;
            }
        }
        return {
            removeAll: removeAll,
            addOne: createStateOperator(addOneMutably),
            addMany: createStateOperator(addManyMutably),
            addAll: createStateOperator(addAllMutably),
            updateOne: createStateOperator(updateOneMutably),
            updateMany: createStateOperator(updateManyMutably),
            upsertOne: createStateOperator(upsertOneMutably),
            upsertMany: createStateOperator(upsertManyMutably),
            removeOne: createStateOperator(removeOneMutably),
            removeMany: createStateOperator(removeManyMutably),
            map: createStateOperator(mapMutably),
        };
    }

    function createSortedStateAdapter(selectId, sort) {
        var _a = createUnsortedStateAdapter(selectId), removeOne = _a.removeOne, removeMany = _a.removeMany, removeAll = _a.removeAll;
        function addOneMutably(entity, state) {
            return addManyMutably([entity], state);
        }
        function addManyMutably(newModels, state) {
            var models = newModels.filter(function (model) { return !(selectIdValue(model, selectId) in state.entities); });
            if (models.length === 0) {
                return DidMutate.None;
            }
            else {
                merge(models, state);
                return DidMutate.Both;
            }
        }
        function addAllMutably(models, state) {
            state.entities = {};
            state.ids = [];
            addManyMutably(models, state);
            return DidMutate.Both;
        }
        function updateOneMutably(update, state) {
            return updateManyMutably([update], state);
        }
        function takeUpdatedModel(models, update, state) {
            if (!(update.id in state.entities)) {
                return false;
            }
            var original = state.entities[update.id];
            var updated = Object.assign({}, original, update.changes);
            var newKey = selectIdValue(updated, selectId);
            delete state.entities[update.id];
            models.push(updated);
            return newKey !== update.id;
        }
        function updateManyMutably(updates, state) {
            var models = [];
            var didMutateIds = updates.filter(function (update) { return takeUpdatedModel(models, update, state); }).length >
                0;
            if (models.length === 0) {
                return DidMutate.None;
            }
            else {
                var originalIds_1 = state.ids;
                var updatedIndexes_1 = [];
                state.ids = state.ids.filter(function (id, index) {
                    if (id in state.entities) {
                        return true;
                    }
                    else {
                        updatedIndexes_1.push(index);
                        return false;
                    }
                });
                merge(models, state);
                if (!didMutateIds &&
                    updatedIndexes_1.every(function (i) { return state.ids[i] === originalIds_1[i]; })) {
                    return DidMutate.EntitiesOnly;
                }
                else {
                    return DidMutate.Both;
                }
            }
        }
        function mapMutably(updatesOrMap, state) {
            var updates = state.ids.reduce(function (changes, id) {
                var change = updatesOrMap(state.entities[id]);
                if (change !== state.entities[id]) {
                    changes.push({ id: id, changes: change });
                }
                return changes;
            }, []);
            return updateManyMutably(updates, state);
        }
        function upsertOneMutably(entity, state) {
            return upsertManyMutably([entity], state);
        }
        function upsertManyMutably(entities, state) {
            var e_1, _a;
            var added = [];
            var updated = [];
            try {
                for (var entities_1 = tslib_1.__values(entities), entities_1_1 = entities_1.next(); !entities_1_1.done; entities_1_1 = entities_1.next()) {
                    var entity = entities_1_1.value;
                    var id = selectIdValue(entity, selectId);
                    if (id in state.entities) {
                        updated.push({ id: id, changes: entity });
                    }
                    else {
                        added.push(entity);
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (entities_1_1 && !entities_1_1.done && (_a = entities_1.return)) _a.call(entities_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            var didMutateByUpdated = updateManyMutably(updated, state);
            var didMutateByAdded = addManyMutably(added, state);
            switch (true) {
                case didMutateByAdded === DidMutate.None &&
                    didMutateByUpdated === DidMutate.None:
                    return DidMutate.None;
                case didMutateByAdded === DidMutate.Both ||
                    didMutateByUpdated === DidMutate.Both:
                    return DidMutate.Both;
                default:
                    return DidMutate.EntitiesOnly;
            }
        }
        function merge(models, state) {
            models.sort(sort);
            var ids = [];
            var i = 0;
            var j = 0;
            while (i < models.length && j < state.ids.length) {
                var model = models[i];
                var modelId = selectIdValue(model, selectId);
                var entityId = state.ids[j];
                var entity = state.entities[entityId];
                if (sort(model, entity) <= 0) {
                    ids.push(modelId);
                    i++;
                }
                else {
                    ids.push(entityId);
                    j++;
                }
            }
            if (i < models.length) {
                state.ids = ids.concat(models.slice(i).map(selectId));
            }
            else {
                state.ids = ids.concat(state.ids.slice(j));
            }
            models.forEach(function (model, i) {
                state.entities[selectId(model)] = model;
            });
        }
        return {
            removeOne: removeOne,
            removeMany: removeMany,
            removeAll: removeAll,
            addOne: createStateOperator(addOneMutably),
            updateOne: createStateOperator(updateOneMutably),
            upsertOne: createStateOperator(upsertOneMutably),
            addAll: createStateOperator(addAllMutably),
            addMany: createStateOperator(addManyMutably),
            updateMany: createStateOperator(updateManyMutably),
            upsertMany: createStateOperator(upsertManyMutably),
            map: createStateOperator(mapMutably),
        };
    }

    function createEntityAdapter(options) {
        if (options === void 0) { options = {}; }
        var _a = tslib_1.__assign({ sortComparer: false, selectId: function (instance) { return instance.id; } }, options), selectId = _a.selectId, sortComparer = _a.sortComparer;
        var stateFactory = createInitialStateFactory();
        var selectorsFactory = createSelectorsFactory();
        var stateAdapter = sortComparer
            ? createSortedStateAdapter(selectId, sortComparer)
            : createUnsortedStateAdapter(selectId);
        return tslib_1.__assign({ selectId: selectId,
            sortComparer: sortComparer }, stateFactory, selectorsFactory, stateAdapter);
    }

    var Dictionary = /** @class */ (function () {
        function Dictionary() {
        }
        return Dictionary;
    }());

    /**
     * DO NOT EDIT
     *
     * This file is automatically generated at build
     */

    /**
     * Generated bundle index. Do not edit.
     */

    exports.createEntityAdapter = createEntityAdapter;
    exports.Dictionary = Dictionary;

    Object.defineProperty(exports, '__esModule', { value: true });

}));
//# sourceMappingURL=entity.umd.js.map
