import { createSelector } from '@ngrx/store';
export function createSelectorsFactory() {
    function getSelectors(selectState) {
        var selectIds = function (state) { return state.ids; };
        var selectEntities = function (state) { return state.entities; };
        var selectAll = createSelector(selectIds, selectEntities, function (ids, entities) {
            return ids.map(function (id) { return entities[id]; });
        });
        var selectTotal = createSelector(selectIds, function (ids) { return ids.length; });
        if (!selectState) {
            return {
                selectIds: selectIds,
                selectEntities: selectEntities,
                selectAll: selectAll,
                selectTotal: selectTotal,
            };
        }
        return {
            selectIds: createSelector(selectState, selectIds),
            selectEntities: createSelector(selectState, selectEntities),
            selectAll: createSelector(selectState, selectAll),
            selectTotal: createSelector(selectState, selectTotal),
        };
    }
    return { getSelectors: getSelectors };
}
//# sourceMappingURL=data:application/json;base64,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