import { createSelector } from '@ngrx/store';
export function getSelectors(selectState) {
    var selectRouterState = createSelector(selectState, function (router) { return router && router.state; });
    var selectCurrentRoute = createSelector(selectRouterState, function (routerState) {
        if (!routerState) {
            return undefined;
        }
        var route = routerState.root;
        while (route.firstChild) {
            route = route.firstChild;
        }
        return route;
    });
    var selectQueryParams = createSelector(selectCurrentRoute, function (route) { return route && route.queryParams; });
    var selectQueryParam = function (param) {
        return createSelector(selectQueryParams, function (params) { return params && params[param]; });
    };
    var selectRouteParams = createSelector(selectCurrentRoute, function (route) { return route && route.params; });
    var selectRouteParam = function (param) {
        return createSelector(selectRouteParams, function (params) { return params && params[param]; });
    };
    var selectRouteData = createSelector(selectCurrentRoute, function (route) { return route && route.data; });
    var selectUrl = createSelector(selectRouterState, function (routerState) { return routerState && routerState.url; });
    return {
        selectCurrentRoute: selectCurrentRoute,
        selectQueryParams: selectQueryParams,
        selectQueryParam: selectQueryParam,
        selectRouteParams: selectRouteParams,
        selectRouteParam: selectRouteParam,
        selectRouteData: selectRouteData,
        selectUrl: selectUrl,
    };
}
//# sourceMappingURL=data:application/json;base64,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