export function isUndefined(target) {
    return target === undefined;
}
export function isNull(target) {
    return target === null;
}
export function isArray(target) {
    return Array.isArray(target);
}
export function isString(target) {
    return typeof target === 'string';
}
export function isBoolean(target) {
    return typeof target === 'boolean';
}
export function isNumber(target) {
    return typeof target === 'number';
}
export function isObjectLike(target) {
    return typeof target === 'object' && target !== null;
}
export function isObject(target) {
    return isObjectLike(target) && !isArray(target);
}
export function isPlainObject(target) {
    if (!isObject(target)) {
        return false;
    }
    var targetPrototype = Object.getPrototypeOf(target);
    return targetPrototype === Object.prototype || targetPrototype === null;
}
export function isFunction(target) {
    return typeof target === 'function';
}
export function hasOwnProperty(target, propertyName) {
    return Object.prototype.hasOwnProperty.call(target, propertyName);
}
//# sourceMappingURL=data:application/json;base64,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