import * as tslib_1 from "tslib";
/** @ng2api @module directives */
/** */
import { UIRouter, extend, isNumber } from '@uirouter/core';
import { Directive, Inject, Input, Optional, ElementRef, Renderer2, HostListener, } from '@angular/core';
import { UIView } from './uiView';
import { ReplaySubject } from 'rxjs';
/**
 * @internalapi
 * # blah blah blah
 */
let AnchorUISref = class AnchorUISref {
    constructor(_el, _renderer) {
        this._el = _el;
        this._renderer = _renderer;
    }
    openInNewTab() {
        return this._el.nativeElement.target === '_blank';
    }
    update(href) {
        if (href && href !== '') {
            this._renderer.setProperty(this._el.nativeElement, 'href', href);
        }
        else {
            this._renderer.removeAttribute(this._el.nativeElement, 'href');
        }
    }
};
AnchorUISref = tslib_1.__decorate([
    Directive({ selector: 'a[uiSref]' }),
    tslib_1.__metadata("design:paramtypes", [ElementRef, Renderer2])
], AnchorUISref);
export { AnchorUISref };
/**
 * A directive when clicked, initiates a [[Transition]] to a [[TargetState]].
 *
 * ### Purpose
 *
 * This directive is applied to anchor tags (`<a>`) or any other clickable element.  It is a state reference (or sref --
 * similar to an href).  When clicked, the directive will transition to that state by calling [[StateService.go]],
 * and optionally supply state parameter values and transition options.
 *
 * When this directive is on an anchor tag, it will also add an `href` attribute to the anchor.
 *
 * ### Selector
 *
 * - `[uiSref]`: The directive is created as an attribute on an element, e.g., `<a uiSref></a>`
 *
 * ### Inputs
 *
 * - `uiSref`: the target state's name, e.g., `uiSref="foostate"`.  If a component template uses a relative `uiSref`,
 * e.g., `uiSref=".child"`, the reference is relative to that component's state.
 *
 * - `uiParams`: any target state parameter values, as an object, e.g., `[uiParams]="{ fooId: bar.fooId }"`
 *
 * - `uiOptions`: [[TransitionOptions]], e.g., `[uiOptions]="{ inherit: false }"`
 *
 * @example
 * ```html
 *
 * <!-- Targets bar state' -->
 * <a uiSref="bar">Bar</a>
 *
 * <!-- Assume this component's state is "foo".
 *      Relatively targets "foo.child" -->
 * <a uiSref=".child">Foo Child</a>
 *
 * <!-- Targets "bar" state and supplies parameter value -->
 * <a uiSref="bar" [uiParams]="{ barId: foo.barId }">Bar {{foo.barId}}</a>
 *
 * <!-- Targets "bar" state and parameter, doesn't inherit existing parameters-->
 * <a uiSref="bar" [uiParams]="{ barId: foo.barId }" [uiOptions]="{ inherit: false }">Bar {{foo.barId}}</a>
 * ```
 */
let UISref = class UISref {
    constructor(_router, _anchorUISref, parent) {
        /**
         * An observable (ReplaySubject) of the state this UISref is targeting.
         * When the UISref is clicked, it will transition to this [[TargetState]].
         */
        this.targetState$ = new ReplaySubject(1);
        /** @internalapi */ this._emit = false;
        this._router = _router;
        this._anchorUISref = _anchorUISref;
        this._parent = parent;
        this._statesSub = _router.globals.states$.subscribe(() => this.update());
    }
    /** @internalapi */
    set uiSref(val) {
        this.state = val;
        this.update();
    }
    /** @internalapi */
    set uiParams(val) {
        this.params = val;
        this.update();
    }
    /** @internalapi */
    set uiOptions(val) {
        this.options = val;
        this.update();
    }
    ngOnInit() {
        this._emit = true;
        this.update();
    }
    ngOnChanges(changes) {
        this.update();
    }
    ngOnDestroy() {
        this._emit = false;
        this._statesSub.unsubscribe();
        this.targetState$.unsubscribe();
    }
    update() {
        const $state = this._router.stateService;
        if (this._emit) {
            const newTarget = $state.target(this.state, this.params, this.getOptions());
            this.targetState$.next(newTarget);
        }
        if (this._anchorUISref) {
            const href = $state.href(this.state, this.params, this.getOptions());
            this._anchorUISref.update(href);
        }
    }
    getOptions() {
        const defaultOpts = {
            relative: this._parent && this._parent.context && this._parent.context.name,
            inherit: true,
            source: 'sref',
        };
        return extend(defaultOpts, this.options || {});
    }
    /** When triggered by a (click) event, this function transitions to the UISref's target state */
    go(button, ctrlKey, metaKey) {
        if ((this._anchorUISref &&
            (this._anchorUISref.openInNewTab() || button || !isNumber(button) || ctrlKey || metaKey)) ||
            !this.state) {
            return;
        }
        this._router.stateService.go(this.state, this.params, this.getOptions());
        return false;
    }
};
tslib_1.__decorate([
    Input('uiSref'),
    tslib_1.__metadata("design:type", String)
], UISref.prototype, "state", void 0);
tslib_1.__decorate([
    Input('uiParams'),
    tslib_1.__metadata("design:type", Object)
], UISref.prototype, "params", void 0);
tslib_1.__decorate([
    Input('uiOptions'),
    tslib_1.__metadata("design:type", Object)
], UISref.prototype, "options", void 0);
tslib_1.__decorate([
    HostListener('click', ['$event.button', '$event.ctrlKey', '$event.metaKey']),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", [Number, Boolean, Boolean]),
    tslib_1.__metadata("design:returntype", void 0)
], UISref.prototype, "go", null);
UISref = tslib_1.__decorate([
    Directive({
        selector: '[uiSref]',
        exportAs: 'uiSref',
    }),
    tslib_1.__param(1, Optional()),
    tslib_1.__param(2, Inject(UIView.PARENT_INJECT)),
    tslib_1.__metadata("design:paramtypes", [UIRouter,
        AnchorUISref, Object])
], UISref);
export { UISref };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidWlTcmVmLmpzIiwic291cmNlUm9vdCI6Im5nOi8vQHVpcm91dGVyL2FuZ3VsYXIvIiwic291cmNlcyI6WyJkaXJlY3RpdmVzL3VpU3JlZi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsaUNBQWlDO0FBQ2pDLE1BQU07QUFDTixPQUFPLEVBQUUsUUFBUSxFQUFFLE1BQU0sRUFBdUMsUUFBUSxFQUFFLE1BQU0sZ0JBQWdCLENBQUM7QUFDakcsT0FBTyxFQUNMLFNBQVMsRUFDVCxNQUFNLEVBQ04sS0FBSyxFQUNMLFFBQVEsRUFDUixVQUFVLEVBQ1YsU0FBUyxFQUdULFlBQVksR0FDYixNQUFNLGVBQWUsQ0FBQztBQUN2QixPQUFPLEVBQUUsTUFBTSxFQUFzQixNQUFNLFVBQVUsQ0FBQztBQUN0RCxPQUFPLEVBQUUsYUFBYSxFQUFnQixNQUFNLE1BQU0sQ0FBQztBQUVuRDs7O0dBR0c7QUFFSCxJQUFhLFlBQVksR0FBekIsTUFBYSxZQUFZO0lBQ3ZCLFlBQW1CLEdBQWUsRUFBUyxTQUFvQjtRQUE1QyxRQUFHLEdBQUgsR0FBRyxDQUFZO1FBQVMsY0FBUyxHQUFULFNBQVMsQ0FBVztJQUFHLENBQUM7SUFDbkUsWUFBWTtRQUNWLE9BQU8sSUFBSSxDQUFDLEdBQUcsQ0FBQyxhQUFhLENBQUMsTUFBTSxLQUFLLFFBQVEsQ0FBQztJQUNwRCxDQUFDO0lBQ0QsTUFBTSxDQUFDLElBQVk7UUFDakIsSUFBSSxJQUFJLElBQUksSUFBSSxLQUFLLEVBQUUsRUFBRTtZQUN2QixJQUFJLENBQUMsU0FBUyxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLGFBQWEsRUFBRSxNQUFNLEVBQUUsSUFBSSxDQUFDLENBQUM7U0FDbEU7YUFBTTtZQUNMLElBQUksQ0FBQyxTQUFTLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsYUFBYSxFQUFFLE1BQU0sQ0FBQyxDQUFDO1NBQ2hFO0lBQ0gsQ0FBQztDQUNGLENBQUE7QUFaWSxZQUFZO0lBRHhCLFNBQVMsQ0FBQyxFQUFFLFFBQVEsRUFBRSxXQUFXLEVBQUUsQ0FBQzs2Q0FFWCxVQUFVLEVBQW9CLFNBQVM7R0FEcEQsWUFBWSxDQVl4QjtTQVpZLFlBQVk7QUFjekI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7R0F3Q0c7QUFLSCxJQUFhLE1BQU0sR0FBbkIsTUFBYSxNQUFNO0lBd0NqQixZQUNFLE9BQWlCLEVBQ0wsYUFBMkIsRUFDVCxNQUEwQjtRQWYxRDs7O1dBR0c7UUFDSSxpQkFBWSxHQUFHLElBQUksYUFBYSxDQUFjLENBQUMsQ0FBQyxDQUFDO1FBRXhELG1CQUFtQixDQUFTLFVBQUssR0FBRyxLQUFLLENBQUM7UUFXeEMsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPLENBQUM7UUFDdkIsSUFBSSxDQUFDLGFBQWEsR0FBRyxhQUFhLENBQUM7UUFDbkMsSUFBSSxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUM7UUFFdEIsSUFBSSxDQUFDLFVBQVUsR0FBRyxPQUFPLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDLENBQUM7SUFDM0UsQ0FBQztJQUVELG1CQUFtQjtJQUNuQixJQUFJLE1BQU0sQ0FBQyxHQUFXO1FBQ3BCLElBQUksQ0FBQyxLQUFLLEdBQUcsR0FBRyxDQUFDO1FBQ2pCLElBQUksQ0FBQyxNQUFNLEVBQUUsQ0FBQztJQUNoQixDQUFDO0lBQ0QsbUJBQW1CO0lBQ25CLElBQUksUUFBUSxDQUFDLEdBQVE7UUFDbkIsSUFBSSxDQUFDLE1BQU0sR0FBRyxHQUFHLENBQUM7UUFDbEIsSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDO0lBQ2hCLENBQUM7SUFDRCxtQkFBbUI7SUFDbkIsSUFBSSxTQUFTLENBQUMsR0FBc0I7UUFDbEMsSUFBSSxDQUFDLE9BQU8sR0FBRyxHQUFHLENBQUM7UUFDbkIsSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDO0lBQ2hCLENBQUM7SUFFRCxRQUFRO1FBQ04sSUFBSSxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUM7UUFDbEIsSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDO0lBQ2hCLENBQUM7SUFFRCxXQUFXLENBQUMsT0FBc0I7UUFDaEMsSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDO0lBQ2hCLENBQUM7SUFFRCxXQUFXO1FBQ1QsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7UUFDbkIsSUFBSSxDQUFDLFVBQVUsQ0FBQyxXQUFXLEVBQUUsQ0FBQztRQUM5QixJQUFJLENBQUMsWUFBWSxDQUFDLFdBQVcsRUFBRSxDQUFDO0lBQ2xDLENBQUM7SUFFTyxNQUFNO1FBQ1osTUFBTSxNQUFNLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUM7UUFDekMsSUFBSSxJQUFJLENBQUMsS0FBSyxFQUFFO1lBQ2QsTUFBTSxTQUFTLEdBQUcsTUFBTSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLFVBQVUsRUFBRSxDQUFDLENBQUM7WUFDNUUsSUFBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUM7U0FDbkM7UUFFRCxJQUFJLElBQUksQ0FBQyxhQUFhLEVBQUU7WUFDdEIsTUFBTSxJQUFJLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLFVBQVUsRUFBRSxDQUFDLENBQUM7WUFDckUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUM7U0FDakM7SUFDSCxDQUFDO0lBRUQsVUFBVTtRQUNSLE1BQU0sV0FBVyxHQUFzQjtZQUNyQyxRQUFRLEVBQUUsSUFBSSxDQUFDLE9BQU8sSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxJQUFJO1lBQzNFLE9BQU8sRUFBRSxJQUFJO1lBQ2IsTUFBTSxFQUFFLE1BQU07U0FDZixDQUFDO1FBQ0YsT0FBTyxNQUFNLENBQUMsV0FBVyxFQUFFLElBQUksQ0FBQyxPQUFPLElBQUksRUFBRSxDQUFDLENBQUM7SUFDakQsQ0FBQztJQUVELGdHQUFnRztJQUVoRyxFQUFFLENBQUMsTUFBYyxFQUFFLE9BQWdCLEVBQUUsT0FBZ0I7UUFDbkQsSUFDRSxDQUFDLElBQUksQ0FBQyxhQUFhO1lBQ2pCLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxZQUFZLEVBQUUsSUFBSSxNQUFNLElBQUksQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLElBQUksT0FBTyxJQUFJLE9BQU8sQ0FBQyxDQUFDO1lBQzNGLENBQUMsSUFBSSxDQUFDLEtBQUssRUFDWDtZQUNBLE9BQU87U0FDUjtRQUVELElBQUksQ0FBQyxPQUFPLENBQUMsWUFBWSxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLFVBQVUsRUFBRSxDQUFDLENBQUM7UUFDekUsT0FBTyxLQUFLLENBQUM7SUFDZixDQUFDO0NBQ0YsQ0FBQTtBQS9Ha0I7SUFBaEIsS0FBSyxDQUFDLFFBQVEsQ0FBQzs7cUNBQWU7QUFTWjtJQUFsQixLQUFLLENBQUMsVUFBVSxDQUFDOztzQ0FBYTtBQVNYO0lBQW5CLEtBQUssQ0FBQyxXQUFXLENBQUM7O3VDQUE0QjtBQWlGL0M7SUFEQyxZQUFZLENBQUMsT0FBTyxFQUFFLENBQUMsZUFBZSxFQUFFLGdCQUFnQixFQUFFLGdCQUFnQixDQUFDLENBQUM7Ozs7Z0NBWTVFO0FBdEhVLE1BQU07SUFKbEIsU0FBUyxDQUFDO1FBQ1QsUUFBUSxFQUFFLFVBQVU7UUFDcEIsUUFBUSxFQUFFLFFBQVE7S0FDbkIsQ0FBQztJQTJDRyxtQkFBQSxRQUFRLEVBQUUsQ0FBQTtJQUNWLG1CQUFBLE1BQU0sQ0FBQyxNQUFNLENBQUMsYUFBYSxDQUFDLENBQUE7NkNBRnBCLFFBQVE7UUFDVSxZQUFZO0dBMUM5QixNQUFNLENBdUhsQjtTQXZIWSxNQUFNIiwic291cmNlc0NvbnRlbnQiOlsiLyoqIEBuZzJhcGkgQG1vZHVsZSBkaXJlY3RpdmVzICovXG4vKiogKi9cbmltcG9ydCB7IFVJUm91dGVyLCBleHRlbmQsIE9iaiwgVHJhbnNpdGlvbk9wdGlvbnMsIFRhcmdldFN0YXRlLCBpc051bWJlciB9IGZyb20gJ0B1aXJvdXRlci9jb3JlJztcbmltcG9ydCB7XG4gIERpcmVjdGl2ZSxcbiAgSW5qZWN0LFxuICBJbnB1dCxcbiAgT3B0aW9uYWwsXG4gIEVsZW1lbnRSZWYsXG4gIFJlbmRlcmVyMixcbiAgT25DaGFuZ2VzLFxuICBTaW1wbGVDaGFuZ2VzLFxuICBIb3N0TGlzdGVuZXIsXG59IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgVUlWaWV3LCBQYXJlbnRVSVZpZXdJbmplY3QgfSBmcm9tICcuL3VpVmlldyc7XG5pbXBvcnQgeyBSZXBsYXlTdWJqZWN0LCBTdWJzY3JpcHRpb24gfSBmcm9tICdyeGpzJztcblxuLyoqXG4gKiBAaW50ZXJuYWxhcGlcbiAqICMgYmxhaCBibGFoIGJsYWhcbiAqL1xuQERpcmVjdGl2ZSh7IHNlbGVjdG9yOiAnYVt1aVNyZWZdJyB9KVxuZXhwb3J0IGNsYXNzIEFuY2hvclVJU3JlZiB7XG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBfZWw6IEVsZW1lbnRSZWYsIHB1YmxpYyBfcmVuZGVyZXI6IFJlbmRlcmVyMikge31cbiAgb3BlbkluTmV3VGFiKCkge1xuICAgIHJldHVybiB0aGlzLl9lbC5uYXRpdmVFbGVtZW50LnRhcmdldCA9PT0gJ19ibGFuayc7XG4gIH1cbiAgdXBkYXRlKGhyZWY6IHN0cmluZykge1xuICAgIGlmIChocmVmICYmIGhyZWYgIT09ICcnKSB7XG4gICAgICB0aGlzLl9yZW5kZXJlci5zZXRQcm9wZXJ0eSh0aGlzLl9lbC5uYXRpdmVFbGVtZW50LCAnaHJlZicsIGhyZWYpO1xuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLl9yZW5kZXJlci5yZW1vdmVBdHRyaWJ1dGUodGhpcy5fZWwubmF0aXZlRWxlbWVudCwgJ2hyZWYnKTtcbiAgICB9XG4gIH1cbn1cblxuLyoqXG4gKiBBIGRpcmVjdGl2ZSB3aGVuIGNsaWNrZWQsIGluaXRpYXRlcyBhIFtbVHJhbnNpdGlvbl1dIHRvIGEgW1tUYXJnZXRTdGF0ZV1dLlxuICpcbiAqICMjIyBQdXJwb3NlXG4gKlxuICogVGhpcyBkaXJlY3RpdmUgaXMgYXBwbGllZCB0byBhbmNob3IgdGFncyAoYDxhPmApIG9yIGFueSBvdGhlciBjbGlja2FibGUgZWxlbWVudC4gIEl0IGlzIGEgc3RhdGUgcmVmZXJlbmNlIChvciBzcmVmIC0tXG4gKiBzaW1pbGFyIHRvIGFuIGhyZWYpLiAgV2hlbiBjbGlja2VkLCB0aGUgZGlyZWN0aXZlIHdpbGwgdHJhbnNpdGlvbiB0byB0aGF0IHN0YXRlIGJ5IGNhbGxpbmcgW1tTdGF0ZVNlcnZpY2UuZ29dXSxcbiAqIGFuZCBvcHRpb25hbGx5IHN1cHBseSBzdGF0ZSBwYXJhbWV0ZXIgdmFsdWVzIGFuZCB0cmFuc2l0aW9uIG9wdGlvbnMuXG4gKlxuICogV2hlbiB0aGlzIGRpcmVjdGl2ZSBpcyBvbiBhbiBhbmNob3IgdGFnLCBpdCB3aWxsIGFsc28gYWRkIGFuIGBocmVmYCBhdHRyaWJ1dGUgdG8gdGhlIGFuY2hvci5cbiAqXG4gKiAjIyMgU2VsZWN0b3JcbiAqXG4gKiAtIGBbdWlTcmVmXWA6IFRoZSBkaXJlY3RpdmUgaXMgY3JlYXRlZCBhcyBhbiBhdHRyaWJ1dGUgb24gYW4gZWxlbWVudCwgZS5nLiwgYDxhIHVpU3JlZj48L2E+YFxuICpcbiAqICMjIyBJbnB1dHNcbiAqXG4gKiAtIGB1aVNyZWZgOiB0aGUgdGFyZ2V0IHN0YXRlJ3MgbmFtZSwgZS5nLiwgYHVpU3JlZj1cImZvb3N0YXRlXCJgLiAgSWYgYSBjb21wb25lbnQgdGVtcGxhdGUgdXNlcyBhIHJlbGF0aXZlIGB1aVNyZWZgLFxuICogZS5nLiwgYHVpU3JlZj1cIi5jaGlsZFwiYCwgdGhlIHJlZmVyZW5jZSBpcyByZWxhdGl2ZSB0byB0aGF0IGNvbXBvbmVudCdzIHN0YXRlLlxuICpcbiAqIC0gYHVpUGFyYW1zYDogYW55IHRhcmdldCBzdGF0ZSBwYXJhbWV0ZXIgdmFsdWVzLCBhcyBhbiBvYmplY3QsIGUuZy4sIGBbdWlQYXJhbXNdPVwieyBmb29JZDogYmFyLmZvb0lkIH1cImBcbiAqXG4gKiAtIGB1aU9wdGlvbnNgOiBbW1RyYW5zaXRpb25PcHRpb25zXV0sIGUuZy4sIGBbdWlPcHRpb25zXT1cInsgaW5oZXJpdDogZmFsc2UgfVwiYFxuICpcbiAqIEBleGFtcGxlXG4gKiBgYGBodG1sXG4gKlxuICogPCEtLSBUYXJnZXRzIGJhciBzdGF0ZScgLS0+XG4gKiA8YSB1aVNyZWY9XCJiYXJcIj5CYXI8L2E+XG4gKlxuICogPCEtLSBBc3N1bWUgdGhpcyBjb21wb25lbnQncyBzdGF0ZSBpcyBcImZvb1wiLlxuICogICAgICBSZWxhdGl2ZWx5IHRhcmdldHMgXCJmb28uY2hpbGRcIiAtLT5cbiAqIDxhIHVpU3JlZj1cIi5jaGlsZFwiPkZvbyBDaGlsZDwvYT5cbiAqXG4gKiA8IS0tIFRhcmdldHMgXCJiYXJcIiBzdGF0ZSBhbmQgc3VwcGxpZXMgcGFyYW1ldGVyIHZhbHVlIC0tPlxuICogPGEgdWlTcmVmPVwiYmFyXCIgW3VpUGFyYW1zXT1cInsgYmFySWQ6IGZvby5iYXJJZCB9XCI+QmFyIHt7Zm9vLmJhcklkfX08L2E+XG4gKlxuICogPCEtLSBUYXJnZXRzIFwiYmFyXCIgc3RhdGUgYW5kIHBhcmFtZXRlciwgZG9lc24ndCBpbmhlcml0IGV4aXN0aW5nIHBhcmFtZXRlcnMtLT5cbiAqIDxhIHVpU3JlZj1cImJhclwiIFt1aVBhcmFtc109XCJ7IGJhcklkOiBmb28uYmFySWQgfVwiIFt1aU9wdGlvbnNdPVwieyBpbmhlcml0OiBmYWxzZSB9XCI+QmFyIHt7Zm9vLmJhcklkfX08L2E+XG4gKiBgYGBcbiAqL1xuQERpcmVjdGl2ZSh7XG4gIHNlbGVjdG9yOiAnW3VpU3JlZl0nLFxuICBleHBvcnRBczogJ3VpU3JlZicsXG59KVxuZXhwb3J0IGNsYXNzIFVJU3JlZiBpbXBsZW1lbnRzIE9uQ2hhbmdlcyB7XG4gIC8qKlxuICAgKiBgQElucHV0KCd1aVNyZWYnKWAgVGhlIG5hbWUgb2YgdGhlIHN0YXRlIHRvIGxpbmsgdG9cbiAgICpcbiAgICogYGBgaHRtbFxuICAgKiA8YSB1aVNyZWY9XCJob29tZVwiPkhvbWU8L2E+XG4gICAqIGBgYFxuICAgKi9cbiAgQElucHV0KCd1aVNyZWYnKSBzdGF0ZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBgQElucHV0KCd1aVBhcmFtcycpYCBUaGUgcGFyYW1ldGVyIHZhbHVlcyB0byB1c2UgKGFzIGtleS92YWx1ZXMpXG4gICAqXG4gICAqIGBgYGh0bWxcbiAgICogPGEgdWlTcmVmPVwiYm9va1wiIFt1aVBhcmFtc109XCJ7IGJvb2tJZDogYm9vay5pZCB9XCI+Qm9vayB7eyBib29rLm5hbWUgfX08L2E+XG4gICAqIGBgYFxuICAgKi9cbiAgQElucHV0KCd1aVBhcmFtcycpIHBhcmFtczogYW55O1xuXG4gIC8qKlxuICAgKiBgQElucHV0KCd1aU9wdGlvbnMnKWAgVGhlIHRyYW5zaXRpb24gb3B0aW9uc1xuICAgKlxuICAgKiBgYGBodG1sXG4gICAqIDxhIHVpU3JlZj1cImJvb2tzXCIgW3VpT3B0aW9uc109XCJ7IHJlbG9hZDogdHJ1ZSB9XCI+Qm9vayB7eyBib29rLm5hbWUgfX08L2E+XG4gICAqIGBgYFxuICAgKi9cbiAgQElucHV0KCd1aU9wdGlvbnMnKSBvcHRpb25zOiBUcmFuc2l0aW9uT3B0aW9ucztcblxuICAvKipcbiAgICogQW4gb2JzZXJ2YWJsZSAoUmVwbGF5U3ViamVjdCkgb2YgdGhlIHN0YXRlIHRoaXMgVUlTcmVmIGlzIHRhcmdldGluZy5cbiAgICogV2hlbiB0aGUgVUlTcmVmIGlzIGNsaWNrZWQsIGl0IHdpbGwgdHJhbnNpdGlvbiB0byB0aGlzIFtbVGFyZ2V0U3RhdGVdXS5cbiAgICovXG4gIHB1YmxpYyB0YXJnZXRTdGF0ZSQgPSBuZXcgUmVwbGF5U3ViamVjdDxUYXJnZXRTdGF0ZT4oMSk7XG5cbiAgLyoqIEBpbnRlcm5hbGFwaSAqLyBwcml2YXRlIF9lbWl0ID0gZmFsc2U7XG4gIC8qKiBAaW50ZXJuYWxhcGkgKi8gcHJpdmF0ZSBfc3RhdGVzU3ViOiBTdWJzY3JpcHRpb247XG4gIC8qKiBAaW50ZXJuYWxhcGkgKi8gcHJpdmF0ZSBfcm91dGVyOiBVSVJvdXRlcjtcbiAgLyoqIEBpbnRlcm5hbGFwaSAqLyBwcml2YXRlIF9hbmNob3JVSVNyZWY6IEFuY2hvclVJU3JlZjtcbiAgLyoqIEBpbnRlcm5hbGFwaSAqLyBwcml2YXRlIF9wYXJlbnQ6IFBhcmVudFVJVmlld0luamVjdDtcblxuICBjb25zdHJ1Y3RvcihcbiAgICBfcm91dGVyOiBVSVJvdXRlcixcbiAgICBAT3B0aW9uYWwoKSBfYW5jaG9yVUlTcmVmOiBBbmNob3JVSVNyZWYsXG4gICAgQEluamVjdChVSVZpZXcuUEFSRU5UX0lOSkVDVCkgcGFyZW50OiBQYXJlbnRVSVZpZXdJbmplY3RcbiAgKSB7XG4gICAgdGhpcy5fcm91dGVyID0gX3JvdXRlcjtcbiAgICB0aGlzLl9hbmNob3JVSVNyZWYgPSBfYW5jaG9yVUlTcmVmO1xuICAgIHRoaXMuX3BhcmVudCA9IHBhcmVudDtcblxuICAgIHRoaXMuX3N0YXRlc1N1YiA9IF9yb3V0ZXIuZ2xvYmFscy5zdGF0ZXMkLnN1YnNjcmliZSgoKSA9PiB0aGlzLnVwZGF0ZSgpKTtcbiAgfVxuXG4gIC8qKiBAaW50ZXJuYWxhcGkgKi9cbiAgc2V0IHVpU3JlZih2YWw6IHN0cmluZykge1xuICAgIHRoaXMuc3RhdGUgPSB2YWw7XG4gICAgdGhpcy51cGRhdGUoKTtcbiAgfVxuICAvKiogQGludGVybmFsYXBpICovXG4gIHNldCB1aVBhcmFtcyh2YWw6IE9iaikge1xuICAgIHRoaXMucGFyYW1zID0gdmFsO1xuICAgIHRoaXMudXBkYXRlKCk7XG4gIH1cbiAgLyoqIEBpbnRlcm5hbGFwaSAqL1xuICBzZXQgdWlPcHRpb25zKHZhbDogVHJhbnNpdGlvbk9wdGlvbnMpIHtcbiAgICB0aGlzLm9wdGlvbnMgPSB2YWw7XG4gICAgdGhpcy51cGRhdGUoKTtcbiAgfVxuXG4gIG5nT25Jbml0KCkge1xuICAgIHRoaXMuX2VtaXQgPSB0cnVlO1xuICAgIHRoaXMudXBkYXRlKCk7XG4gIH1cblxuICBuZ09uQ2hhbmdlcyhjaGFuZ2VzOiBTaW1wbGVDaGFuZ2VzKTogdm9pZCB7XG4gICAgdGhpcy51cGRhdGUoKTtcbiAgfVxuXG4gIG5nT25EZXN0cm95KCkge1xuICAgIHRoaXMuX2VtaXQgPSBmYWxzZTtcbiAgICB0aGlzLl9zdGF0ZXNTdWIudW5zdWJzY3JpYmUoKTtcbiAgICB0aGlzLnRhcmdldFN0YXRlJC51bnN1YnNjcmliZSgpO1xuICB9XG5cbiAgcHJpdmF0ZSB1cGRhdGUoKSB7XG4gICAgY29uc3QgJHN0YXRlID0gdGhpcy5fcm91dGVyLnN0YXRlU2VydmljZTtcbiAgICBpZiAodGhpcy5fZW1pdCkge1xuICAgICAgY29uc3QgbmV3VGFyZ2V0ID0gJHN0YXRlLnRhcmdldCh0aGlzLnN0YXRlLCB0aGlzLnBhcmFtcywgdGhpcy5nZXRPcHRpb25zKCkpO1xuICAgICAgdGhpcy50YXJnZXRTdGF0ZSQubmV4dChuZXdUYXJnZXQpO1xuICAgIH1cblxuICAgIGlmICh0aGlzLl9hbmNob3JVSVNyZWYpIHtcbiAgICAgIGNvbnN0IGhyZWYgPSAkc3RhdGUuaHJlZih0aGlzLnN0YXRlLCB0aGlzLnBhcmFtcywgdGhpcy5nZXRPcHRpb25zKCkpO1xuICAgICAgdGhpcy5fYW5jaG9yVUlTcmVmLnVwZGF0ZShocmVmKTtcbiAgICB9XG4gIH1cblxuICBnZXRPcHRpb25zKCkge1xuICAgIGNvbnN0IGRlZmF1bHRPcHRzOiBUcmFuc2l0aW9uT3B0aW9ucyA9IHtcbiAgICAgIHJlbGF0aXZlOiB0aGlzLl9wYXJlbnQgJiYgdGhpcy5fcGFyZW50LmNvbnRleHQgJiYgdGhpcy5fcGFyZW50LmNvbnRleHQubmFtZSxcbiAgICAgIGluaGVyaXQ6IHRydWUsXG4gICAgICBzb3VyY2U6ICdzcmVmJyxcbiAgICB9O1xuICAgIHJldHVybiBleHRlbmQoZGVmYXVsdE9wdHMsIHRoaXMub3B0aW9ucyB8fCB7fSk7XG4gIH1cblxuICAvKiogV2hlbiB0cmlnZ2VyZWQgYnkgYSAoY2xpY2spIGV2ZW50LCB0aGlzIGZ1bmN0aW9uIHRyYW5zaXRpb25zIHRvIHRoZSBVSVNyZWYncyB0YXJnZXQgc3RhdGUgKi9cbiAgQEhvc3RMaXN0ZW5lcignY2xpY2snLCBbJyRldmVudC5idXR0b24nLCAnJGV2ZW50LmN0cmxLZXknLCAnJGV2ZW50Lm1ldGFLZXknXSlcbiAgZ28oYnV0dG9uOiBudW1iZXIsIGN0cmxLZXk6IGJvb2xlYW4sIG1ldGFLZXk6IGJvb2xlYW4pIHtcbiAgICBpZiAoXG4gICAgICAodGhpcy5fYW5jaG9yVUlTcmVmICYmXG4gICAgICAgICh0aGlzLl9hbmNob3JVSVNyZWYub3BlbkluTmV3VGFiKCkgfHwgYnV0dG9uIHx8ICFpc051bWJlcihidXR0b24pIHx8IGN0cmxLZXkgfHwgbWV0YUtleSkpIHx8XG4gICAgICAhdGhpcy5zdGF0ZVxuICAgICkge1xuICAgICAgcmV0dXJuO1xuICAgIH1cblxuICAgIHRoaXMuX3JvdXRlci5zdGF0ZVNlcnZpY2UuZ28odGhpcy5zdGF0ZSwgdGhpcy5wYXJhbXMsIHRoaXMuZ2V0T3B0aW9ucygpKTtcbiAgICByZXR1cm4gZmFsc2U7XG4gIH1cbn1cbiJdfQ==