import * as tslib_1 from "tslib";
/** @ng2api @module directives */ /** */
import { Directive, Input, ElementRef, Host, Renderer2 } from '@angular/core';
import { UISrefStatus } from './uiSrefStatus';
/**
 * A directive that adds a CSS class when its associated `uiSref` link is active.
 *
 * ### Purpose
 *
 * This directive should be paired with one (or more) [[UISref]] directives.
 * It will apply a CSS class to its element when the state the `uiSref` targets is activated.
 *
 * This can be used to create navigation UI where the active link is highlighted.
 *
 * ### Selectors
 *
 * - `[uiSrefActive]`: When this selector is used, the class is added when the target state or any
 * child of the target state is active
 * - `[uiSrefActiveEq]`: When this selector is used, the class is added when the target state is
 * exactly active (the class is not added if a child of the target state is active).
 *
 * ### Inputs
 *
 * - `uiSrefActive`/`uiSrefActiveEq`: one or more CSS classes to add to the element, when the `uiSref` is active
 *
 * #### Example:
 * The anchor tag has the `active` class added when the `foo` state is active.
 * ```html
 * <a uiSref="foo" uiSrefActive="active">Foo</a>
 * ```
 *
 * ### Matching parameters
 *
 * If the `uiSref` includes parameters, the current state must be active, *and* the parameter values must match.
 *
 * #### Example:
 * The first anchor tag has the `active` class added when the `foo.bar` state is active and the `id` parameter
 * equals 25.
 * The second anchor tag has the `active` class added when the `foo.bar` state is active and the `id` parameter
 * equals 32.
 * ```html
 * <a uiSref="foo.bar" [uiParams]="{ id: 25 }" uiSrefActive="active">Bar #25</a>
 * <a uiSref="foo.bar" [uiParams]="{ id: 32 }" uiSrefActive="active">Bar #32</a>
 * ```
 *
 * #### Example:
 * A list of anchor tags are created for a list of `bar` objects.
 * An anchor tag will have the `active` class when `foo.bar` state is active and the `id` parameter matches
 * that object's `id`.
 * ```html
 * <li *ngFor="let bar of bars">
 *   <a uiSref="foo.bar" [uiParams]="{ id: bar.id }" uiSrefActive="active">Bar #{{ bar.id }}</a>
 * </li>
 * ```
 *
 * ### Multiple uiSrefs
 *
 * A single `uiSrefActive` can be used for multiple `uiSref` links.
 * This can be used to create (for example) a drop down navigation menu, where the menui is highlighted
 * if *any* of its inner links are active.
 *
 * The `uiSrefActive` should be placed on an ancestor element of the `uiSref` list.
 * If anyof the `uiSref` links are activated, the class will be added to the ancestor element.
 *
 * #### Example:
 * This is a dropdown nagivation menu for "Admin" states.
 * When any of `admin.users`, `admin.groups`, `admin.settings` are active, the `<li>` for the dropdown
 * has the `dropdown-child-active` class applied.
 * Additionally, the active anchor tag has the `active` class applied.
 * ```html
 * <ul class="dropdown-menu">
 *   <li uiSrefActive="dropdown-child-active" class="dropdown admin">
 *     Admin
 *     <ul>
 *       <li><a uiSref="admin.users" uiSrefActive="active">Users</a></li>
 *       <li><a uiSref="admin.groups" uiSrefActive="active">Groups</a></li>
 *       <li><a uiSref="admin.settings" uiSrefActive="active">Settings</a></li>
 *     </ul>
 *   </li>
 * </ul>
 * ```
 */
let UISrefActive = class UISrefActive {
    constructor(uiSrefStatus, rnd, host) {
        this._classes = [];
        this._classesEq = [];
        this._subscription = uiSrefStatus.uiSrefStatus.subscribe((next) => {
            this._classes.forEach(cls => {
                if (next.active) {
                    rnd.addClass(host.nativeElement, cls);
                }
                else {
                    rnd.removeClass(host.nativeElement, cls);
                }
            });
            this._classesEq.forEach(cls => {
                if (next.exact) {
                    rnd.addClass(host.nativeElement, cls);
                }
                else {
                    rnd.removeClass(host.nativeElement, cls);
                }
            });
        });
    }
    set active(val) {
        this._classes = val.split(/\s+/);
    }
    set activeEq(val) {
        this._classesEq = val.split(/\s+/);
    }
    ngOnDestroy() {
        this._subscription.unsubscribe();
    }
};
tslib_1.__decorate([
    Input('uiSrefActive'),
    tslib_1.__metadata("design:type", String),
    tslib_1.__metadata("design:paramtypes", [String])
], UISrefActive.prototype, "active", null);
tslib_1.__decorate([
    Input('uiSrefActiveEq'),
    tslib_1.__metadata("design:type", String),
    tslib_1.__metadata("design:paramtypes", [String])
], UISrefActive.prototype, "activeEq", null);
UISrefActive = tslib_1.__decorate([
    Directive({
        selector: '[uiSrefActive],[uiSrefActiveEq]',
    }),
    tslib_1.__param(2, Host()),
    tslib_1.__metadata("design:paramtypes", [UISrefStatus, Renderer2, ElementRef])
], UISrefActive);
export { UISrefActive };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidWlTcmVmQWN0aXZlLmpzIiwic291cmNlUm9vdCI6Im5nOi8vQHVpcm91dGVyL2FuZ3VsYXIvIiwic291cmNlcyI6WyJkaXJlY3RpdmVzL3VpU3JlZkFjdGl2ZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsaUNBQWlDLENBQUMsTUFBTTtBQUN4QyxPQUFPLEVBQUUsU0FBUyxFQUFFLEtBQUssRUFBRSxVQUFVLEVBQUUsSUFBSSxFQUFFLFNBQVMsRUFBRSxNQUFNLGVBQWUsQ0FBQztBQUM5RSxPQUFPLEVBQUUsWUFBWSxFQUFjLE1BQU0sZ0JBQWdCLENBQUM7QUFHMUQ7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBNkVHO0FBSUgsSUFBYSxZQUFZLEdBQXpCLE1BQWEsWUFBWTtJQWN2QixZQUFZLFlBQTBCLEVBQUUsR0FBYyxFQUFVLElBQWdCO1FBYnhFLGFBQVEsR0FBYSxFQUFFLENBQUM7UUFNeEIsZUFBVSxHQUFhLEVBQUUsQ0FBQztRQVFoQyxJQUFJLENBQUMsYUFBYSxHQUFHLFlBQVksQ0FBQyxZQUFZLENBQUMsU0FBUyxDQUFDLENBQUMsSUFBZ0IsRUFBRSxFQUFFO1lBQzVFLElBQUksQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxFQUFFO2dCQUMxQixJQUFJLElBQUksQ0FBQyxNQUFNLEVBQUU7b0JBQ2YsR0FBRyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxDQUFDO2lCQUN2QztxQkFBTTtvQkFDTCxHQUFHLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLENBQUM7aUJBQzFDO1lBQ0gsQ0FBQyxDQUFDLENBQUM7WUFDSCxJQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsRUFBRTtnQkFDNUIsSUFBSSxJQUFJLENBQUMsS0FBSyxFQUFFO29CQUNkLEdBQUcsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsQ0FBQztpQkFDdkM7cUJBQU07b0JBQ0wsR0FBRyxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxDQUFDO2lCQUMxQztZQUNILENBQUMsQ0FBQyxDQUFDO1FBQ0wsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDO0lBNUJELElBQUksTUFBTSxDQUFDLEdBQVc7UUFDcEIsSUFBSSxDQUFDLFFBQVEsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ25DLENBQUM7SUFJRCxJQUFJLFFBQVEsQ0FBQyxHQUFXO1FBQ3RCLElBQUksQ0FBQyxVQUFVLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUNyQyxDQUFDO0lBc0JELFdBQVc7UUFDVCxJQUFJLENBQUMsYUFBYSxDQUFDLFdBQVcsRUFBRSxDQUFDO0lBQ25DLENBQUM7Q0FDRixDQUFBO0FBakNDO0lBREMsS0FBSyxDQUFDLGNBQWMsQ0FBQzs7OzBDQUdyQjtBQUlEO0lBREMsS0FBSyxDQUFDLGdCQUFnQixDQUFDOzs7NENBR3ZCO0FBWFUsWUFBWTtJQUh4QixTQUFTLENBQUM7UUFDVCxRQUFRLEVBQUUsaUNBQWlDO0tBQzVDLENBQUM7SUFleUQsbUJBQUEsSUFBSSxFQUFFLENBQUE7NkNBQXJDLFlBQVksRUFBTyxTQUFTLEVBQWdCLFVBQVU7R0FkckUsWUFBWSxDQW9DeEI7U0FwQ1ksWUFBWSIsInNvdXJjZXNDb250ZW50IjpbIi8qKiBAbmcyYXBpIEBtb2R1bGUgZGlyZWN0aXZlcyAqLyAvKiogKi9cbmltcG9ydCB7IERpcmVjdGl2ZSwgSW5wdXQsIEVsZW1lbnRSZWYsIEhvc3QsIFJlbmRlcmVyMiB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgVUlTcmVmU3RhdHVzLCBTcmVmU3RhdHVzIH0gZnJvbSAnLi91aVNyZWZTdGF0dXMnO1xuaW1wb3J0IHsgU3Vic2NyaXB0aW9uIH0gZnJvbSAncnhqcyc7XG5cbi8qKlxuICogQSBkaXJlY3RpdmUgdGhhdCBhZGRzIGEgQ1NTIGNsYXNzIHdoZW4gaXRzIGFzc29jaWF0ZWQgYHVpU3JlZmAgbGluayBpcyBhY3RpdmUuXG4gKlxuICogIyMjIFB1cnBvc2VcbiAqXG4gKiBUaGlzIGRpcmVjdGl2ZSBzaG91bGQgYmUgcGFpcmVkIHdpdGggb25lIChvciBtb3JlKSBbW1VJU3JlZl1dIGRpcmVjdGl2ZXMuXG4gKiBJdCB3aWxsIGFwcGx5IGEgQ1NTIGNsYXNzIHRvIGl0cyBlbGVtZW50IHdoZW4gdGhlIHN0YXRlIHRoZSBgdWlTcmVmYCB0YXJnZXRzIGlzIGFjdGl2YXRlZC5cbiAqXG4gKiBUaGlzIGNhbiBiZSB1c2VkIHRvIGNyZWF0ZSBuYXZpZ2F0aW9uIFVJIHdoZXJlIHRoZSBhY3RpdmUgbGluayBpcyBoaWdobGlnaHRlZC5cbiAqXG4gKiAjIyMgU2VsZWN0b3JzXG4gKlxuICogLSBgW3VpU3JlZkFjdGl2ZV1gOiBXaGVuIHRoaXMgc2VsZWN0b3IgaXMgdXNlZCwgdGhlIGNsYXNzIGlzIGFkZGVkIHdoZW4gdGhlIHRhcmdldCBzdGF0ZSBvciBhbnlcbiAqIGNoaWxkIG9mIHRoZSB0YXJnZXQgc3RhdGUgaXMgYWN0aXZlXG4gKiAtIGBbdWlTcmVmQWN0aXZlRXFdYDogV2hlbiB0aGlzIHNlbGVjdG9yIGlzIHVzZWQsIHRoZSBjbGFzcyBpcyBhZGRlZCB3aGVuIHRoZSB0YXJnZXQgc3RhdGUgaXNcbiAqIGV4YWN0bHkgYWN0aXZlICh0aGUgY2xhc3MgaXMgbm90IGFkZGVkIGlmIGEgY2hpbGQgb2YgdGhlIHRhcmdldCBzdGF0ZSBpcyBhY3RpdmUpLlxuICpcbiAqICMjIyBJbnB1dHNcbiAqXG4gKiAtIGB1aVNyZWZBY3RpdmVgL2B1aVNyZWZBY3RpdmVFcWA6IG9uZSBvciBtb3JlIENTUyBjbGFzc2VzIHRvIGFkZCB0byB0aGUgZWxlbWVudCwgd2hlbiB0aGUgYHVpU3JlZmAgaXMgYWN0aXZlXG4gKlxuICogIyMjIyBFeGFtcGxlOlxuICogVGhlIGFuY2hvciB0YWcgaGFzIHRoZSBgYWN0aXZlYCBjbGFzcyBhZGRlZCB3aGVuIHRoZSBgZm9vYCBzdGF0ZSBpcyBhY3RpdmUuXG4gKiBgYGBodG1sXG4gKiA8YSB1aVNyZWY9XCJmb29cIiB1aVNyZWZBY3RpdmU9XCJhY3RpdmVcIj5Gb288L2E+XG4gKiBgYGBcbiAqXG4gKiAjIyMgTWF0Y2hpbmcgcGFyYW1ldGVyc1xuICpcbiAqIElmIHRoZSBgdWlTcmVmYCBpbmNsdWRlcyBwYXJhbWV0ZXJzLCB0aGUgY3VycmVudCBzdGF0ZSBtdXN0IGJlIGFjdGl2ZSwgKmFuZCogdGhlIHBhcmFtZXRlciB2YWx1ZXMgbXVzdCBtYXRjaC5cbiAqXG4gKiAjIyMjIEV4YW1wbGU6XG4gKiBUaGUgZmlyc3QgYW5jaG9yIHRhZyBoYXMgdGhlIGBhY3RpdmVgIGNsYXNzIGFkZGVkIHdoZW4gdGhlIGBmb28uYmFyYCBzdGF0ZSBpcyBhY3RpdmUgYW5kIHRoZSBgaWRgIHBhcmFtZXRlclxuICogZXF1YWxzIDI1LlxuICogVGhlIHNlY29uZCBhbmNob3IgdGFnIGhhcyB0aGUgYGFjdGl2ZWAgY2xhc3MgYWRkZWQgd2hlbiB0aGUgYGZvby5iYXJgIHN0YXRlIGlzIGFjdGl2ZSBhbmQgdGhlIGBpZGAgcGFyYW1ldGVyXG4gKiBlcXVhbHMgMzIuXG4gKiBgYGBodG1sXG4gKiA8YSB1aVNyZWY9XCJmb28uYmFyXCIgW3VpUGFyYW1zXT1cInsgaWQ6IDI1IH1cIiB1aVNyZWZBY3RpdmU9XCJhY3RpdmVcIj5CYXIgIzI1PC9hPlxuICogPGEgdWlTcmVmPVwiZm9vLmJhclwiIFt1aVBhcmFtc109XCJ7IGlkOiAzMiB9XCIgdWlTcmVmQWN0aXZlPVwiYWN0aXZlXCI+QmFyICMzMjwvYT5cbiAqIGBgYFxuICpcbiAqICMjIyMgRXhhbXBsZTpcbiAqIEEgbGlzdCBvZiBhbmNob3IgdGFncyBhcmUgY3JlYXRlZCBmb3IgYSBsaXN0IG9mIGBiYXJgIG9iamVjdHMuXG4gKiBBbiBhbmNob3IgdGFnIHdpbGwgaGF2ZSB0aGUgYGFjdGl2ZWAgY2xhc3Mgd2hlbiBgZm9vLmJhcmAgc3RhdGUgaXMgYWN0aXZlIGFuZCB0aGUgYGlkYCBwYXJhbWV0ZXIgbWF0Y2hlc1xuICogdGhhdCBvYmplY3QncyBgaWRgLlxuICogYGBgaHRtbFxuICogPGxpICpuZ0Zvcj1cImxldCBiYXIgb2YgYmFyc1wiPlxuICogICA8YSB1aVNyZWY9XCJmb28uYmFyXCIgW3VpUGFyYW1zXT1cInsgaWQ6IGJhci5pZCB9XCIgdWlTcmVmQWN0aXZlPVwiYWN0aXZlXCI+QmFyICN7eyBiYXIuaWQgfX08L2E+XG4gKiA8L2xpPlxuICogYGBgXG4gKlxuICogIyMjIE11bHRpcGxlIHVpU3JlZnNcbiAqXG4gKiBBIHNpbmdsZSBgdWlTcmVmQWN0aXZlYCBjYW4gYmUgdXNlZCBmb3IgbXVsdGlwbGUgYHVpU3JlZmAgbGlua3MuXG4gKiBUaGlzIGNhbiBiZSB1c2VkIHRvIGNyZWF0ZSAoZm9yIGV4YW1wbGUpIGEgZHJvcCBkb3duIG5hdmlnYXRpb24gbWVudSwgd2hlcmUgdGhlIG1lbnVpIGlzIGhpZ2hsaWdodGVkXG4gKiBpZiAqYW55KiBvZiBpdHMgaW5uZXIgbGlua3MgYXJlIGFjdGl2ZS5cbiAqXG4gKiBUaGUgYHVpU3JlZkFjdGl2ZWAgc2hvdWxkIGJlIHBsYWNlZCBvbiBhbiBhbmNlc3RvciBlbGVtZW50IG9mIHRoZSBgdWlTcmVmYCBsaXN0LlxuICogSWYgYW55b2YgdGhlIGB1aVNyZWZgIGxpbmtzIGFyZSBhY3RpdmF0ZWQsIHRoZSBjbGFzcyB3aWxsIGJlIGFkZGVkIHRvIHRoZSBhbmNlc3RvciBlbGVtZW50LlxuICpcbiAqICMjIyMgRXhhbXBsZTpcbiAqIFRoaXMgaXMgYSBkcm9wZG93biBuYWdpdmF0aW9uIG1lbnUgZm9yIFwiQWRtaW5cIiBzdGF0ZXMuXG4gKiBXaGVuIGFueSBvZiBgYWRtaW4udXNlcnNgLCBgYWRtaW4uZ3JvdXBzYCwgYGFkbWluLnNldHRpbmdzYCBhcmUgYWN0aXZlLCB0aGUgYDxsaT5gIGZvciB0aGUgZHJvcGRvd25cbiAqIGhhcyB0aGUgYGRyb3Bkb3duLWNoaWxkLWFjdGl2ZWAgY2xhc3MgYXBwbGllZC5cbiAqIEFkZGl0aW9uYWxseSwgdGhlIGFjdGl2ZSBhbmNob3IgdGFnIGhhcyB0aGUgYGFjdGl2ZWAgY2xhc3MgYXBwbGllZC5cbiAqIGBgYGh0bWxcbiAqIDx1bCBjbGFzcz1cImRyb3Bkb3duLW1lbnVcIj5cbiAqICAgPGxpIHVpU3JlZkFjdGl2ZT1cImRyb3Bkb3duLWNoaWxkLWFjdGl2ZVwiIGNsYXNzPVwiZHJvcGRvd24gYWRtaW5cIj5cbiAqICAgICBBZG1pblxuICogICAgIDx1bD5cbiAqICAgICAgIDxsaT48YSB1aVNyZWY9XCJhZG1pbi51c2Vyc1wiIHVpU3JlZkFjdGl2ZT1cImFjdGl2ZVwiPlVzZXJzPC9hPjwvbGk+XG4gKiAgICAgICA8bGk+PGEgdWlTcmVmPVwiYWRtaW4uZ3JvdXBzXCIgdWlTcmVmQWN0aXZlPVwiYWN0aXZlXCI+R3JvdXBzPC9hPjwvbGk+XG4gKiAgICAgICA8bGk+PGEgdWlTcmVmPVwiYWRtaW4uc2V0dGluZ3NcIiB1aVNyZWZBY3RpdmU9XCJhY3RpdmVcIj5TZXR0aW5nczwvYT48L2xpPlxuICogICAgIDwvdWw+XG4gKiAgIDwvbGk+XG4gKiA8L3VsPlxuICogYGBgXG4gKi9cbkBEaXJlY3RpdmUoe1xuICBzZWxlY3RvcjogJ1t1aVNyZWZBY3RpdmVdLFt1aVNyZWZBY3RpdmVFcV0nLFxufSlcbmV4cG9ydCBjbGFzcyBVSVNyZWZBY3RpdmUge1xuICBwcml2YXRlIF9jbGFzc2VzOiBzdHJpbmdbXSA9IFtdO1xuICBASW5wdXQoJ3VpU3JlZkFjdGl2ZScpXG4gIHNldCBhY3RpdmUodmFsOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9jbGFzc2VzID0gdmFsLnNwbGl0KC9cXHMrLyk7XG4gIH1cblxuICBwcml2YXRlIF9jbGFzc2VzRXE6IHN0cmluZ1tdID0gW107XG4gIEBJbnB1dCgndWlTcmVmQWN0aXZlRXEnKVxuICBzZXQgYWN0aXZlRXEodmFsOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9jbGFzc2VzRXEgPSB2YWwuc3BsaXQoL1xccysvKTtcbiAgfVxuXG4gIHByaXZhdGUgX3N1YnNjcmlwdGlvbjogU3Vic2NyaXB0aW9uO1xuICBjb25zdHJ1Y3Rvcih1aVNyZWZTdGF0dXM6IFVJU3JlZlN0YXR1cywgcm5kOiBSZW5kZXJlcjIsIEBIb3N0KCkgaG9zdDogRWxlbWVudFJlZikge1xuICAgIHRoaXMuX3N1YnNjcmlwdGlvbiA9IHVpU3JlZlN0YXR1cy51aVNyZWZTdGF0dXMuc3Vic2NyaWJlKChuZXh0OiBTcmVmU3RhdHVzKSA9PiB7XG4gICAgICB0aGlzLl9jbGFzc2VzLmZvckVhY2goY2xzID0+IHtcbiAgICAgICAgaWYgKG5leHQuYWN0aXZlKSB7XG4gICAgICAgICAgcm5kLmFkZENsYXNzKGhvc3QubmF0aXZlRWxlbWVudCwgY2xzKTtcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICBybmQucmVtb3ZlQ2xhc3MoaG9zdC5uYXRpdmVFbGVtZW50LCBjbHMpO1xuICAgICAgICB9XG4gICAgICB9KTtcbiAgICAgIHRoaXMuX2NsYXNzZXNFcS5mb3JFYWNoKGNscyA9PiB7XG4gICAgICAgIGlmIChuZXh0LmV4YWN0KSB7XG4gICAgICAgICAgcm5kLmFkZENsYXNzKGhvc3QubmF0aXZlRWxlbWVudCwgY2xzKTtcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICBybmQucmVtb3ZlQ2xhc3MoaG9zdC5uYXRpdmVFbGVtZW50LCBjbHMpO1xuICAgICAgICB9XG4gICAgICB9KTtcbiAgICB9KTtcbiAgfVxuXG4gIG5nT25EZXN0cm95KCkge1xuICAgIHRoaXMuX3N1YnNjcmlwdGlvbi51bnN1YnNjcmliZSgpO1xuICB9XG59XG4iXX0=