/** @module ng2 */
/** */
import { BaseLocationServices, parseUrl } from '@uirouter/core';
/** A `LocationServices` that delegates to the Angular LocationStrategy */
export class Ng2LocationServices extends BaseLocationServices {
    constructor(router, _locationStrategy, isBrowser) {
        super(router, isBrowser);
        this._locationStrategy = _locationStrategy;
        this._locationStrategy.onPopState(evt => {
            if (evt.type !== 'hashchange') {
                this._listener(evt);
            }
        });
    }
    _get() {
        return this._locationStrategy.path(true).replace(this._locationStrategy.getBaseHref().replace(/\/$/, ''), '');
    }
    _set(state, title, url, replace) {
        const { path, search, hash } = parseUrl(url);
        const urlWithHash = path + (hash ? '#' + hash : '');
        if (replace) {
            this._locationStrategy.replaceState(state, title, urlWithHash, search);
        }
        else {
            this._locationStrategy.pushState(state, title, urlWithHash, search);
        }
    }
    dispose(router) {
        super.dispose(router);
    }
}
//# sourceMappingURL=data:application/json;base64,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