/**
 * Merge two injectors
 *
 * This class implements the Injector ng2 interface but delegates
 * to the Injectors provided in the constructor.
 */
export class MergeInjector {
    constructor(...injectors) {
        if (injectors.length < 2)
            throw new Error('pass at least two injectors');
        this.injectors = injectors;
    }
    /**
     * Get the token from the first injector which contains it.
     *
     * Delegates to the first Injector.get().
     * If not found, then delegates to the second Injector (and so forth).
     * If no Injector contains the token, return the `notFoundValue`, or throw.
     *
     * @param token the DI token
     * @param notFoundValue the value to return if none of the Injectors contains the token.
     * @returns {any} the DI value
     */
    get(token, notFoundValue) {
        for (let i = 0; i < this.injectors.length; i++) {
            const val = this.injectors[i].get(token, MergeInjector.NOT_FOUND);
            if (val !== MergeInjector.NOT_FOUND)
                return val;
        }
        if (arguments.length >= 2)
            return notFoundValue;
        // This will throw the DI Injector error
        this.injectors[0].get(token);
    }
}
MergeInjector.NOT_FOUND = {};
//# sourceMappingURL=data:application/json;base64,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