var UIRouterModule_1;
import * as tslib_1 from "tslib";
import { NgModule, ANALYZE_FOR_ENTRY_COMPONENTS, InjectionToken, APP_INITIALIZER, } from '@angular/core';
import { CommonModule, LocationStrategy, HashLocationStrategy, PathLocationStrategy, } from '@angular/common';
import { _UIROUTER_DIRECTIVES } from './directives/directives';
import { UIView } from './directives/uiView';
import { TransitionService } from '@uirouter/core';
import { _UIROUTER_INSTANCE_PROVIDERS, _UIROUTER_SERVICE_PROVIDERS } from './providers';
/** @hidden */ export const UIROUTER_ROOT_MODULE = new InjectionToken('UIRouter Root Module');
/** @hidden */ export const UIROUTER_MODULE_TOKEN = new InjectionToken('UIRouter Module');
/** @hidden */ export const UIROUTER_STATES = new InjectionToken('UIRouter States');
// Delay angular bootstrap until first transition is successful, for SSR.
// See https://github.com/ui-router/angular/pull/127
export function onTransitionReady(transitionService, root) {
    const mod = root[0];
    if (!mod || !mod.deferInitialRender) {
        return () => Promise.resolve();
    }
    return () => new Promise(resolve => {
        const hook = trans => {
            trans.promise.then(resolve, resolve);
        };
        transitionService.onStart({}, hook, { invokeLimit: 1 });
    });
}
export function makeRootProviders(module) {
    return [
        { provide: UIROUTER_ROOT_MODULE, useValue: module, multi: true },
        { provide: UIROUTER_MODULE_TOKEN, useValue: module, multi: true },
        { provide: ANALYZE_FOR_ENTRY_COMPONENTS, useValue: module.states || [], multi: true },
        {
            provide: APP_INITIALIZER,
            useFactory: onTransitionReady,
            deps: [TransitionService, UIROUTER_ROOT_MODULE],
            multi: true,
        },
    ];
}
export function makeChildProviders(module) {
    return [
        { provide: UIROUTER_MODULE_TOKEN, useValue: module, multi: true },
        { provide: ANALYZE_FOR_ENTRY_COMPONENTS, useValue: module.states || [], multi: true },
    ];
}
export function locationStrategy(useHash) {
    return { provide: LocationStrategy, useClass: useHash ? HashLocationStrategy : PathLocationStrategy };
}
/**
 * Creates UI-Router Modules
 *
 * This class has two static factory methods which create UIRouter Modules.
 * A UI-Router Module is an [Angular NgModule](https://angular.io/docs/ts/latest/guide/ngmodule.html)
 * with support for UI-Router.
 *
 * ### UIRouter Directives
 *
 * When a UI-Router Module is imported into a `NgModule`, that module's components
 * can use the UIRouter Directives such as [[UIView]], [[UISref]], [[UISrefActive]].
 *
 * ### State Definitions
 *
 * State definitions found in the `states:` property are provided to the Dependency Injector.
 * This enables UI-Router to automatically register the states with the [[StateRegistry]] at bootstrap (and during lazy load).
 *
 * ### Entry Components
 *
 * Any routed components are added as `entryComponents:` so they will get compiled.
 */
let UIRouterModule = UIRouterModule_1 = class UIRouterModule {
    /**
     * Creates a UI-Router Module for the root (bootstrapped) application module to import
     *
     * This factory function creates an [Angular NgModule](https://angular.io/docs/ts/latest/guide/ngmodule.html)
     * with UI-Router support.
     *
     * The `forRoot` module should be added to the `imports:` of the `NgModule` being bootstrapped.
     * An application should only create and import a single `NgModule` using `forRoot()`.
     * All other modules should be created using [[UIRouterModule.forChild]].
     *
     * Unlike `forChild`, an `NgModule` returned by this factory provides the [[UIRouter]] singleton object.
     * This factory also accepts root-level router configuration.
     * These are the only differences between `forRoot` and `forChild`.
     *
     * Example:
     * ```js
     * let routerConfig = {
     *   otherwise: '/home',
     *   states: [homeState, aboutState]
     * };
     *
     * @ NgModule({
     *   imports: [
     *     BrowserModule,
     *     UIRouterModule.forRoot(routerConfig),
     *     FeatureModule1
     *   ]
     * })
     * class MyRootAppModule {}
     *
     * browserPlatformDynamic.bootstrapModule(MyRootAppModule);
     * ```
     *
     * @param config declarative UI-Router configuration
     * @returns an `NgModule` which provides the [[UIRouter]] singleton instance
     */
    static forRoot(config = {}) {
        return {
            ngModule: UIRouterModule_1,
            providers: [
                _UIROUTER_INSTANCE_PROVIDERS,
                _UIROUTER_SERVICE_PROVIDERS,
                locationStrategy(config.useHash),
                ...makeRootProviders(config),
            ],
        };
    }
    /**
     * Creates an `NgModule` for a UIRouter module
     *
     * This function creates an [Angular NgModule](https://angular.io/docs/ts/latest/guide/ngmodule.html)
     * with UI-Router support.
     *
     * #### Example:
     * ```js
     * var homeState = { name: 'home', url: '/home', component: Home };
     * var aboutState = { name: 'about', url: '/about', component: About };
     *
     * @ NgModule({
     *   imports: [
     *     UIRouterModule.forChild({ states: [ homeState, aboutState ] }),
     *     SharedModule,
     *   ],
     *   declarations: [ Home, About ],
     * })
     * export class AppModule {};
     * ```
     *
     * @param module UI-Router module options
     * @returns an `NgModule`
     */
    static forChild(module = {}) {
        return {
            ngModule: UIRouterModule_1,
            providers: makeChildProviders(module),
        };
    }
};
UIRouterModule = UIRouterModule_1 = tslib_1.__decorate([
    NgModule({
        imports: [CommonModule],
        declarations: [_UIROUTER_DIRECTIVES],
        exports: [_UIROUTER_DIRECTIVES],
        entryComponents: [UIView],
    })
], UIRouterModule);
export { UIRouterModule };
//# sourceMappingURL=data:application/json;base64,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