import * as tslib_1 from "tslib";
/** @ng2api @module directives */
/** */
import { UIRouter, extend, isNumber } from '@uirouter/core';
import { Directive, Inject, Input, Optional, ElementRef, Renderer2, HostListener, } from '@angular/core';
import { UIView } from './uiView';
import { ReplaySubject } from 'rxjs';
/**
 * @internalapi
 * # blah blah blah
 */
var AnchorUISref = /** @class */ (function () {
    function AnchorUISref(_el, _renderer) {
        this._el = _el;
        this._renderer = _renderer;
    }
    AnchorUISref.prototype.openInNewTab = function () {
        return this._el.nativeElement.target === '_blank';
    };
    AnchorUISref.prototype.update = function (href) {
        if (href && href !== '') {
            this._renderer.setProperty(this._el.nativeElement, 'href', href);
        }
        else {
            this._renderer.removeAttribute(this._el.nativeElement, 'href');
        }
    };
    AnchorUISref = tslib_1.__decorate([
        Directive({ selector: 'a[uiSref]' }),
        tslib_1.__metadata("design:paramtypes", [ElementRef, Renderer2])
    ], AnchorUISref);
    return AnchorUISref;
}());
export { AnchorUISref };
/**
 * A directive when clicked, initiates a [[Transition]] to a [[TargetState]].
 *
 * ### Purpose
 *
 * This directive is applied to anchor tags (`<a>`) or any other clickable element.  It is a state reference (or sref --
 * similar to an href).  When clicked, the directive will transition to that state by calling [[StateService.go]],
 * and optionally supply state parameter values and transition options.
 *
 * When this directive is on an anchor tag, it will also add an `href` attribute to the anchor.
 *
 * ### Selector
 *
 * - `[uiSref]`: The directive is created as an attribute on an element, e.g., `<a uiSref></a>`
 *
 * ### Inputs
 *
 * - `uiSref`: the target state's name, e.g., `uiSref="foostate"`.  If a component template uses a relative `uiSref`,
 * e.g., `uiSref=".child"`, the reference is relative to that component's state.
 *
 * - `uiParams`: any target state parameter values, as an object, e.g., `[uiParams]="{ fooId: bar.fooId }"`
 *
 * - `uiOptions`: [[TransitionOptions]], e.g., `[uiOptions]="{ inherit: false }"`
 *
 * @example
 * ```html
 *
 * <!-- Targets bar state' -->
 * <a uiSref="bar">Bar</a>
 *
 * <!-- Assume this component's state is "foo".
 *      Relatively targets "foo.child" -->
 * <a uiSref=".child">Foo Child</a>
 *
 * <!-- Targets "bar" state and supplies parameter value -->
 * <a uiSref="bar" [uiParams]="{ barId: foo.barId }">Bar {{foo.barId}}</a>
 *
 * <!-- Targets "bar" state and parameter, doesn't inherit existing parameters-->
 * <a uiSref="bar" [uiParams]="{ barId: foo.barId }" [uiOptions]="{ inherit: false }">Bar {{foo.barId}}</a>
 * ```
 */
var UISref = /** @class */ (function () {
    function UISref(_router, _anchorUISref, parent) {
        var _this = this;
        /**
         * An observable (ReplaySubject) of the state this UISref is targeting.
         * When the UISref is clicked, it will transition to this [[TargetState]].
         */
        this.targetState$ = new ReplaySubject(1);
        /** @internalapi */ this._emit = false;
        this._router = _router;
        this._anchorUISref = _anchorUISref;
        this._parent = parent;
        this._statesSub = _router.globals.states$.subscribe(function () { return _this.update(); });
    }
    Object.defineProperty(UISref.prototype, "uiSref", {
        /** @internalapi */
        set: function (val) {
            this.state = val;
            this.update();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(UISref.prototype, "uiParams", {
        /** @internalapi */
        set: function (val) {
            this.params = val;
            this.update();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(UISref.prototype, "uiOptions", {
        /** @internalapi */
        set: function (val) {
            this.options = val;
            this.update();
        },
        enumerable: true,
        configurable: true
    });
    UISref.prototype.ngOnInit = function () {
        this._emit = true;
        this.update();
    };
    UISref.prototype.ngOnChanges = function (changes) {
        this.update();
    };
    UISref.prototype.ngOnDestroy = function () {
        this._emit = false;
        this._statesSub.unsubscribe();
        this.targetState$.unsubscribe();
    };
    UISref.prototype.update = function () {
        var $state = this._router.stateService;
        if (this._emit) {
            var newTarget = $state.target(this.state, this.params, this.getOptions());
            this.targetState$.next(newTarget);
        }
        if (this._anchorUISref) {
            var href = $state.href(this.state, this.params, this.getOptions());
            this._anchorUISref.update(href);
        }
    };
    UISref.prototype.getOptions = function () {
        var defaultOpts = {
            relative: this._parent && this._parent.context && this._parent.context.name,
            inherit: true,
            source: 'sref',
        };
        return extend(defaultOpts, this.options || {});
    };
    /** When triggered by a (click) event, this function transitions to the UISref's target state */
    UISref.prototype.go = function (button, ctrlKey, metaKey) {
        if ((this._anchorUISref &&
            (this._anchorUISref.openInNewTab() || button || !isNumber(button) || ctrlKey || metaKey)) ||
            !this.state) {
            return;
        }
        this._router.stateService.go(this.state, this.params, this.getOptions());
        return false;
    };
    tslib_1.__decorate([
        Input('uiSref'),
        tslib_1.__metadata("design:type", String)
    ], UISref.prototype, "state", void 0);
    tslib_1.__decorate([
        Input('uiParams'),
        tslib_1.__metadata("design:type", Object)
    ], UISref.prototype, "params", void 0);
    tslib_1.__decorate([
        Input('uiOptions'),
        tslib_1.__metadata("design:type", Object)
    ], UISref.prototype, "options", void 0);
    tslib_1.__decorate([
        HostListener('click', ['$event.button', '$event.ctrlKey', '$event.metaKey']),
        tslib_1.__metadata("design:type", Function),
        tslib_1.__metadata("design:paramtypes", [Number, Boolean, Boolean]),
        tslib_1.__metadata("design:returntype", void 0)
    ], UISref.prototype, "go", null);
    UISref = tslib_1.__decorate([
        Directive({
            selector: '[uiSref]',
            exportAs: 'uiSref',
        }),
        tslib_1.__param(1, Optional()),
        tslib_1.__param(2, Inject(UIView.PARENT_INJECT)),
        tslib_1.__metadata("design:paramtypes", [UIRouter,
            AnchorUISref, Object])
    ], UISref);
    return UISref;
}());
export { UISref };
//# sourceMappingURL=data:application/json;base64,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