import * as tslib_1 from "tslib";
/** @ng2api @module directives */ /** */
import { Directive, Input, ElementRef, Host, Renderer2 } from '@angular/core';
import { UISrefStatus } from './uiSrefStatus';
/**
 * A directive that adds a CSS class when its associated `uiSref` link is active.
 *
 * ### Purpose
 *
 * This directive should be paired with one (or more) [[UISref]] directives.
 * It will apply a CSS class to its element when the state the `uiSref` targets is activated.
 *
 * This can be used to create navigation UI where the active link is highlighted.
 *
 * ### Selectors
 *
 * - `[uiSrefActive]`: When this selector is used, the class is added when the target state or any
 * child of the target state is active
 * - `[uiSrefActiveEq]`: When this selector is used, the class is added when the target state is
 * exactly active (the class is not added if a child of the target state is active).
 *
 * ### Inputs
 *
 * - `uiSrefActive`/`uiSrefActiveEq`: one or more CSS classes to add to the element, when the `uiSref` is active
 *
 * #### Example:
 * The anchor tag has the `active` class added when the `foo` state is active.
 * ```html
 * <a uiSref="foo" uiSrefActive="active">Foo</a>
 * ```
 *
 * ### Matching parameters
 *
 * If the `uiSref` includes parameters, the current state must be active, *and* the parameter values must match.
 *
 * #### Example:
 * The first anchor tag has the `active` class added when the `foo.bar` state is active and the `id` parameter
 * equals 25.
 * The second anchor tag has the `active` class added when the `foo.bar` state is active and the `id` parameter
 * equals 32.
 * ```html
 * <a uiSref="foo.bar" [uiParams]="{ id: 25 }" uiSrefActive="active">Bar #25</a>
 * <a uiSref="foo.bar" [uiParams]="{ id: 32 }" uiSrefActive="active">Bar #32</a>
 * ```
 *
 * #### Example:
 * A list of anchor tags are created for a list of `bar` objects.
 * An anchor tag will have the `active` class when `foo.bar` state is active and the `id` parameter matches
 * that object's `id`.
 * ```html
 * <li *ngFor="let bar of bars">
 *   <a uiSref="foo.bar" [uiParams]="{ id: bar.id }" uiSrefActive="active">Bar #{{ bar.id }}</a>
 * </li>
 * ```
 *
 * ### Multiple uiSrefs
 *
 * A single `uiSrefActive` can be used for multiple `uiSref` links.
 * This can be used to create (for example) a drop down navigation menu, where the menui is highlighted
 * if *any* of its inner links are active.
 *
 * The `uiSrefActive` should be placed on an ancestor element of the `uiSref` list.
 * If anyof the `uiSref` links are activated, the class will be added to the ancestor element.
 *
 * #### Example:
 * This is a dropdown nagivation menu for "Admin" states.
 * When any of `admin.users`, `admin.groups`, `admin.settings` are active, the `<li>` for the dropdown
 * has the `dropdown-child-active` class applied.
 * Additionally, the active anchor tag has the `active` class applied.
 * ```html
 * <ul class="dropdown-menu">
 *   <li uiSrefActive="dropdown-child-active" class="dropdown admin">
 *     Admin
 *     <ul>
 *       <li><a uiSref="admin.users" uiSrefActive="active">Users</a></li>
 *       <li><a uiSref="admin.groups" uiSrefActive="active">Groups</a></li>
 *       <li><a uiSref="admin.settings" uiSrefActive="active">Settings</a></li>
 *     </ul>
 *   </li>
 * </ul>
 * ```
 */
var UISrefActive = /** @class */ (function () {
    function UISrefActive(uiSrefStatus, rnd, host) {
        var _this = this;
        this._classes = [];
        this._classesEq = [];
        this._subscription = uiSrefStatus.uiSrefStatus.subscribe(function (next) {
            _this._classes.forEach(function (cls) {
                if (next.active) {
                    rnd.addClass(host.nativeElement, cls);
                }
                else {
                    rnd.removeClass(host.nativeElement, cls);
                }
            });
            _this._classesEq.forEach(function (cls) {
                if (next.exact) {
                    rnd.addClass(host.nativeElement, cls);
                }
                else {
                    rnd.removeClass(host.nativeElement, cls);
                }
            });
        });
    }
    Object.defineProperty(UISrefActive.prototype, "active", {
        set: function (val) {
            this._classes = val.split(/\s+/);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(UISrefActive.prototype, "activeEq", {
        set: function (val) {
            this._classesEq = val.split(/\s+/);
        },
        enumerable: true,
        configurable: true
    });
    UISrefActive.prototype.ngOnDestroy = function () {
        this._subscription.unsubscribe();
    };
    tslib_1.__decorate([
        Input('uiSrefActive'),
        tslib_1.__metadata("design:type", String),
        tslib_1.__metadata("design:paramtypes", [String])
    ], UISrefActive.prototype, "active", null);
    tslib_1.__decorate([
        Input('uiSrefActiveEq'),
        tslib_1.__metadata("design:type", String),
        tslib_1.__metadata("design:paramtypes", [String])
    ], UISrefActive.prototype, "activeEq", null);
    UISrefActive = tslib_1.__decorate([
        Directive({
            selector: '[uiSrefActive],[uiSrefActiveEq]',
        }),
        tslib_1.__param(2, Host()),
        tslib_1.__metadata("design:paramtypes", [UISrefStatus, Renderer2, ElementRef])
    ], UISrefActive);
    return UISrefActive;
}());
export { UISrefActive };
//# sourceMappingURL=data:application/json;base64,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