import * as tslib_1 from "tslib";
/** @ng2api @module directives */
/** */
import { Component, ComponentFactoryResolver, Inject, Input, ReflectiveInjector, ViewChild, ViewContainerRef, } from '@angular/core';
import { filter, inArray, isFunction, NATIVE_INJECTOR_TOKEN, parse, ResolveContext, trace, UIRouter, unnestR, } from '@uirouter/core';
import { Ng2ViewConfig } from '../statebuilders/views';
import { MergeInjector } from '../mergeInjector';
/** @hidden */
var id = 0;
/**
 * Given a component class, gets the inputs of styles:
 *
 * - @Input('foo') _foo
 * - `inputs: ['foo']`
 *
 * @internalapi
 */
var ng2ComponentInputs = function (factory) {
    return factory.inputs.map(function (input) { return ({ prop: input.propName, token: input.templateName }); });
};
var ɵ0 = ng2ComponentInputs;
/**
 * A UI-Router viewport directive, which is filled in by a view (component) on a state.
 *
 * ### Selector
 *
 * A `ui-view` directive can be created as an element: `<ui-view></ui-view>` or as an attribute: `<div ui-view></div>`.
 *
 * ### Purpose
 *
 * This directive is used in a Component template (or as the root component) to create a viewport.  The viewport
 * is filled in by a view (as defined by a [[Ng2ViewDeclaration]] inside a [[Ng2StateDeclaration]]) when the view's
 * state has been activated.
 *
 * #### Example:
 * ```js
 * // This app has two states, 'foo' and 'bar'
 * stateRegistry.register({ name: 'foo', url: '/foo', component: FooComponent });
 * stateRegistry.register({ name: 'bar', url: '/bar', component: BarComponent });
 * ```
 * ```html
 * <!-- This ui-view will be filled in by the foo state's component or
 *      the bar state's component when the foo or bar state is activated -->
 * <ui-view></ui-view>
 * ```
 *
 * ### Named ui-views
 *
 * A `ui-view` may optionally be given a name via the attribute value: `<div ui-view='header'></div>`.  *Note:
 * an unnamed `ui-view` is internally named `$default`*.   When a `ui-view` has a name, it will be filled in
 * by a matching named view.
 *
 * #### Example:
 * ```js
 * stateRegistry.register({
 *   name: 'foo',
 *   url: '/foo',
 *   views: { header: HeaderComponent, $default: FooComponent });
 * ```
 * ```html
 * <!-- When 'foo' state is active, filled by HeaderComponent -->
 * <div ui-view="header"></div>
 *
 * <!-- When 'foo' state is active, filled by FooComponent -->
 * <ui-view></ui-view>
 * ```
 */
var UIView = /** @class */ (function () {
    function UIView(router, parent, viewContainerRef) {
        this.router = router;
        this.viewContainerRef = viewContainerRef;
        /** Data about the this UIView */
        this._uiViewData = {};
        this._parent = parent;
    }
    UIView_1 = UIView;
    Object.defineProperty(UIView.prototype, "_name", {
        set: function (val) {
            this.name = val;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(UIView.prototype, "state", {
        /**
         * @returns the UI-Router `state` that is filling this uiView, or `undefined`.
         */
        get: function () {
            return parse('_uiViewData.config.viewDecl.$context.self')(this);
        },
        enumerable: true,
        configurable: true
    });
    UIView.prototype.ngOnInit = function () {
        var _this = this;
        var router = this.router;
        var parentFqn = this._parent.fqn;
        var name = this.name || '$default';
        this._uiViewData = {
            $type: 'ng2',
            id: id++,
            name: name,
            fqn: parentFqn ? parentFqn + '.' + name : name,
            creationContext: this._parent.context,
            configUpdated: this._viewConfigUpdated.bind(this),
            config: undefined,
        };
        this._deregisterUiCanExitHook = router.transitionService.onBefore({}, function (trans) {
            return _this._invokeUiCanExitHook(trans);
        });
        this._deregisterUiOnParamsChangedHook = router.transitionService.onSuccess({}, function (trans) {
            return _this._invokeUiOnParamsChangedHook(trans);
        });
        this._deregisterUIView = router.viewService.registerUIView(this._uiViewData);
    };
    /**
     * For each transition, checks the component loaded in the ui-view for:
     *
     * - has a uiCanExit() component hook
     * - is being exited
     *
     * If both are true, adds the uiCanExit component function as a hook to that singular Transition.
     */
    UIView.prototype._invokeUiCanExitHook = function (trans) {
        var instance = this._componentRef && this._componentRef.instance;
        var uiCanExitFn = instance && instance.uiCanExit;
        if (isFunction(uiCanExitFn)) {
            var state = this.state;
            if (trans.exiting().indexOf(state) !== -1) {
                trans.onStart({}, function () {
                    return uiCanExitFn.call(instance, trans);
                });
            }
        }
    };
    /**
     * For each transition, checks if any param values changed and notify component
     */
    UIView.prototype._invokeUiOnParamsChangedHook = function ($transition$) {
        var instance = this._componentRef && this._componentRef.instance;
        var uiOnParamsChanged = instance && instance.uiOnParamsChanged;
        if (isFunction(uiOnParamsChanged)) {
            var viewState = this.state;
            var resolveContext = new ResolveContext(this._uiViewData.config.path);
            var viewCreationTrans = resolveContext.getResolvable('$transition$').data;
            // Exit early if the $transition$ is the same as the view was created within.
            // Exit early if the $transition$ will exit the state the view is for.
            if ($transition$ === viewCreationTrans || $transition$.exiting().indexOf(viewState) !== -1)
                return;
            var toParams_1 = $transition$.params('to');
            var fromParams_1 = $transition$.params('from');
            var getNodeSchema = function (node) { return node.paramSchema; };
            var toSchema = $transition$
                .treeChanges('to')
                .map(getNodeSchema)
                .reduce(unnestR, []);
            var fromSchema_1 = $transition$
                .treeChanges('from')
                .map(getNodeSchema)
                .reduce(unnestR, []);
            // Find the to params that have different values than the from params
            var changedToParams = toSchema.filter(function (param) {
                var idx = fromSchema_1.indexOf(param);
                return idx === -1 || !fromSchema_1[idx].type.equals(toParams_1[param.id], fromParams_1[param.id]);
            });
            // Only trigger callback if a to param has changed or is new
            if (changedToParams.length) {
                var changedKeys_1 = changedToParams.map(function (x) { return x.id; });
                // Filter the params to only changed/new to params.  `$transition$.params()` may be used to get all params.
                var newValues = filter(toParams_1, function (val, key) { return changedKeys_1.indexOf(key) !== -1; });
                instance.uiOnParamsChanged(newValues, $transition$);
            }
        }
    };
    UIView.prototype._disposeLast = function () {
        if (this._componentRef)
            this._componentRef.destroy();
        this._componentRef = null;
    };
    UIView.prototype.ngOnDestroy = function () {
        if (this._deregisterUIView)
            this._deregisterUIView();
        if (this._deregisterUiCanExitHook)
            this._deregisterUiCanExitHook();
        if (this._deregisterUiOnParamsChangedHook)
            this._deregisterUiOnParamsChangedHook();
        this._deregisterUIView = this._deregisterUiCanExitHook = this._deregisterUiOnParamsChangedHook = null;
        this._disposeLast();
    };
    /**
     * The view service is informing us of an updated ViewConfig
     * (usually because a transition activated some state and its views)
     */
    UIView.prototype._viewConfigUpdated = function (config) {
        // The config may be undefined if there is nothing currently targeting this UIView.
        // Dispose the current component, if there is one
        if (!config)
            return this._disposeLast();
        // Only care about Ng2 configs
        if (!(config instanceof Ng2ViewConfig))
            return;
        // The "new" viewconfig is already applied, so exit early
        if (this._uiViewData.config === config)
            return;
        // This is a new ViewConfig.  Dispose the previous component
        this._disposeLast();
        trace.traceUIViewConfigUpdated(this._uiViewData, config && config.viewDecl.$context);
        this._applyUpdatedConfig(config);
        // Initiate change detection for the newly created component
        this._componentRef.changeDetectorRef.markForCheck();
    };
    UIView.prototype._applyUpdatedConfig = function (config) {
        this._uiViewData.config = config;
        // Create the Injector for the routed component
        var context = new ResolveContext(config.path);
        var componentInjector = this._getComponentInjector(context);
        // Get the component class from the view declaration. TODO: allow promises?
        var componentClass = config.viewDecl.component;
        // Create the component
        var compFactoryResolver = componentInjector.get(ComponentFactoryResolver);
        var compFactory = compFactoryResolver.resolveComponentFactory(componentClass);
        this._componentRef = this._componentTarget.createComponent(compFactory, undefined, componentInjector);
        // Wire resolves to @Input()s
        this._applyInputBindings(compFactory, this._componentRef.instance, context, componentClass);
    };
    /**
     * Creates a new Injector for a routed component.
     *
     * Adds resolve values to the Injector
     * Adds providers from the NgModule for the state
     * Adds providers from the parent Component in the component tree
     * Adds a PARENT_INJECT view context object
     *
     * @returns an Injector
     */
    UIView.prototype._getComponentInjector = function (context) {
        // Map resolves to "useValue: providers"
        var resolvables = context
            .getTokens()
            .map(function (token) { return context.getResolvable(token); })
            .filter(function (r) { return r.resolved; });
        var newProviders = resolvables.map(function (r) { return ({ provide: r.token, useValue: context.injector().get(r.token) }); });
        var parentInject = { context: this._uiViewData.config.viewDecl.$context, fqn: this._uiViewData.fqn };
        newProviders.push({ provide: UIView_1.PARENT_INJECT, useValue: parentInject });
        var parentComponentInjector = this.viewContainerRef.injector;
        var moduleInjector = context.getResolvable(NATIVE_INJECTOR_TOKEN).data;
        var mergedParentInjector = new MergeInjector(moduleInjector, parentComponentInjector);
        return ReflectiveInjector.resolveAndCreate(newProviders, mergedParentInjector);
    };
    /**
     * Supplies component inputs with resolve data
     *
     * Finds component inputs which match resolves (by name) and sets the input value
     * to the resolve data.
     */
    UIView.prototype._applyInputBindings = function (factory, component, context, componentClass) {
        var bindings = this._uiViewData.config.viewDecl['bindings'] || {};
        var explicitBoundProps = Object.keys(bindings);
        // Returns the actual component property for a renamed an input renamed using `@Input('foo') _foo`.
        // return the `_foo` property
        var renamedInputProp = function (prop) {
            var input = factory.inputs.find(function (i) { return i.templateName === prop; });
            return (input && input.propName) || prop;
        };
        // Supply resolve data to component as specified in the state's `bindings: {}`
        var explicitInputTuples = explicitBoundProps.reduce(function (acc, key) { return acc.concat([{ prop: renamedInputProp(key), token: bindings[key] }]); }, []);
        // Supply resolve data to matching @Input('prop') or inputs: ['prop']
        var implicitInputTuples = ng2ComponentInputs(factory).filter(function (tuple) { return !inArray(explicitBoundProps, tuple.prop); });
        var addResolvable = function (tuple) { return ({
            prop: tuple.prop,
            resolvable: context.getResolvable(tuple.token),
        }); };
        var injector = context.injector();
        explicitInputTuples
            .concat(implicitInputTuples)
            .map(addResolvable)
            .filter(function (tuple) { return tuple.resolvable && tuple.resolvable.resolved; })
            .forEach(function (tuple) {
            component[tuple.prop] = injector.get(tuple.resolvable.token);
        });
    };
    var UIView_1;
    UIView.PARENT_INJECT = 'UIView.PARENT_INJECT';
    tslib_1.__decorate([
        ViewChild('componentTarget', { read: ViewContainerRef, static: true }),
        tslib_1.__metadata("design:type", ViewContainerRef)
    ], UIView.prototype, "_componentTarget", void 0);
    tslib_1.__decorate([
        Input('name'),
        tslib_1.__metadata("design:type", String)
    ], UIView.prototype, "name", void 0);
    tslib_1.__decorate([
        Input('ui-view'),
        tslib_1.__metadata("design:type", String),
        tslib_1.__metadata("design:paramtypes", [String])
    ], UIView.prototype, "_name", null);
    UIView = UIView_1 = tslib_1.__decorate([
        Component({
            selector: 'ui-view, [ui-view]',
            exportAs: 'uiView',
            template: "\n    <ng-template #componentTarget></ng-template>\n    <ng-content *ngIf=\"!_componentRef\"></ng-content>\n  "
        }),
        tslib_1.__param(1, Inject(UIView_1.PARENT_INJECT)),
        tslib_1.__metadata("design:paramtypes", [UIRouter, Object, ViewContainerRef])
    ], UIView);
    return UIView;
}());
export { UIView };
export { ɵ0 };
//# sourceMappingURL=data:application/json;base64,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