import * as tslib_1 from "tslib";
/** @module ng2 */
/** */
import { BaseLocationServices, parseUrl } from '@uirouter/core';
/** A `LocationServices` that delegates to the Angular LocationStrategy */
var Ng2LocationServices = /** @class */ (function (_super) {
    tslib_1.__extends(Ng2LocationServices, _super);
    function Ng2LocationServices(router, _locationStrategy, isBrowser) {
        var _this = _super.call(this, router, isBrowser) || this;
        _this._locationStrategy = _locationStrategy;
        _this._locationStrategy.onPopState(function (evt) {
            if (evt.type !== 'hashchange') {
                _this._listener(evt);
            }
        });
        return _this;
    }
    Ng2LocationServices.prototype._get = function () {
        return this._locationStrategy.path(true).replace(this._locationStrategy.getBaseHref().replace(/\/$/, ''), '');
    };
    Ng2LocationServices.prototype._set = function (state, title, url, replace) {
        var _a = parseUrl(url), path = _a.path, search = _a.search, hash = _a.hash;
        var urlWithHash = path + (hash ? '#' + hash : '');
        if (replace) {
            this._locationStrategy.replaceState(state, title, urlWithHash, search);
        }
        else {
            this._locationStrategy.pushState(state, title, urlWithHash, search);
        }
    };
    Ng2LocationServices.prototype.dispose = function (router) {
        _super.prototype.dispose.call(this, router);
    };
    return Ng2LocationServices;
}(BaseLocationServices));
export { Ng2LocationServices };
//# sourceMappingURL=data:application/json;base64,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