/** @module ng2 */ /** */
import { isFunction } from '@uirouter/core';
import { pick, forEach } from '@uirouter/core';
import { services } from '@uirouter/core';
import { ViewService } from '@uirouter/core';
/**
 * This is a [[StateBuilder.builder]] function for Angular `views`.
 *
 * When the [[StateBuilder]] builds a [[State]] object from a raw [[StateDeclaration]], this builder
 * handles the `views` property with logic specific to @uirouter/angular.
 *
 * If no `views: {}` property exists on the [[StateDeclaration]], then it creates the `views` object and
 * applies the state-level configuration to a view named `$default`.
 */
export function ng2ViewsBuilder(state) {
    var views = {}, viewsObject = state.views || { $default: pick(state, ['component', 'bindings']) };
    forEach(viewsObject, function (config, name) {
        name = name || '$default'; // Account for views: { "": { template... } }
        if (isFunction(config))
            config = { component: config };
        if (Object.keys(config).length === 0)
            return;
        config.$type = 'ng2';
        config.$context = state;
        config.$name = name;
        var normalized = ViewService.normalizeUIViewTarget(config.$context, config.$name);
        config.$uiViewName = normalized.uiViewName;
        config.$uiViewContextAnchor = normalized.uiViewContextAnchor;
        views[name] = config;
    });
    return views;
}
var id = 0;
var Ng2ViewConfig = /** @class */ (function () {
    function Ng2ViewConfig(path, viewDecl) {
        this.path = path;
        this.viewDecl = viewDecl;
        this.$id = id++;
        this.loaded = true;
    }
    Ng2ViewConfig.prototype.load = function () {
        return services.$q.when(this);
    };
    return Ng2ViewConfig;
}());
export { Ng2ViewConfig };
//# sourceMappingURL=data:application/json;base64,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