/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as Highcharts from 'highcharts';
import { AsyncSubject } from 'rxjs';
export class Chart {
    /**
     * @param {?=} options
     */
    constructor(options = { series: [] }) {
        this.options = options;
        this.refSubject = new AsyncSubject();
        this.ref$ = this.refSubject.asObservable();
    }
    /**
     * Add Point
     * @param {?} point         Highcharts.DataPoint, number touple or number
     * @param {?=} serieIndex    Index position of series. This defaults to 0.
     * @param {?=} redraw        Flag whether or not to redraw point. This defaults to true.
     * @param {?=} shift         Shift point to the start of series. This defaults to false.
     * @return {?}
     */
    addPoint(point, serieIndex = 0, redraw = true, shift = false) {
        this.ref$.subscribe((/**
         * @param {?} chart
         * @return {?}
         */
        chart => {
            if (chart.series.length > serieIndex) {
                chart.series[serieIndex].addPoint(point, redraw, shift);
            }
        }));
    }
    /**
     * Add Series
     * @param {?} series        Series Configuration
     * @param {?=} redraw        Flag whether or not to redraw series. This defaults to true.
     * @param {?=} animation     Whether to apply animation, and optionally animation configuration. This defaults to false.
     * @return {?}
     */
    addSeries(series, redraw = true, animation) {
        this.ref$.subscribe((/**
         * @param {?} chart
         * @return {?}
         */
        chart => {
            chart.addSeries(series, redraw, animation);
        }));
    }
    /**
     * Remove Point
     * @param {?} pointIndex    Index of Point
     * @param {?=} serieIndex    Specified Index of Series. Defaults to 0.
     * @return {?}
     */
    removePoint(pointIndex, serieIndex = 0) {
        this.ref$.subscribe((/**
         * @param {?} chart
         * @return {?}
         */
        chart => {
            if (chart.series.length > serieIndex && chart.series[serieIndex].data.length > pointIndex) {
                chart.series[serieIndex].removePoint(pointIndex, true);
            }
        }));
    }
    /**
     * Remove Series
     * @param {?} seriesIndex    Index position of series to remove.
     * @return {?}
     */
    removeSeries(seriesIndex) {
        this.ref$.subscribe((/**
         * @param {?} chart
         * @return {?}
         */
        chart => {
            if (chart.series.length > seriesIndex) {
                chart.series[seriesIndex].remove(true);
            }
        }));
    }
    /**
     * @param {?} el
     * @return {?}
     */
    init(el) {
        if (!this.ref) {
            Highcharts.chart(el.nativeElement, this.options, (/**
             * @param {?} chart
             * @return {?}
             */
            chart => {
                this.refSubject.next(chart);
                this.ref = chart;
                this.refSubject.complete();
            }));
        }
    }
    /**
     * @return {?}
     */
    destroy() {
        if (this.ref) {
            this.options = this.ref.options;
            this.ref.destroy();
            this.ref = undefined;
            // new init subject
            this.refSubject = new AsyncSubject();
            this.ref$ = this.refSubject.asObservable();
        }
    }
}
if (false) {
    /**
     * @type {?}
     * @private
     */
    Chart.prototype.refSubject;
    /** @type {?} */
    Chart.prototype.ref$;
    /** @type {?} */
    Chart.prototype.ref;
    /**
     * @type {?}
     * @private
     */
    Chart.prototype.options;
}
//# sourceMappingURL=data:application/json;base64,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