/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * @license
 * Copyright Felix Itzenplitz. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at
 * https://github.com/cebor/angular-highcharts/blob/master/LICENSE
 */
import { Inject, Injectable, InjectionToken } from '@angular/core';
import * as Highcharts from 'highcharts';
/** @type {?} */
export let HIGHCHARTS_MODULES = new InjectionToken('HighchartsModules');
export class ChartService {
    /**
     * @param {?} chartModules
     */
    constructor(chartModules) {
        this.chartModules = chartModules;
    }
    /**
     * @return {?}
     */
    initModules() {
        this.chartModules.forEach((/**
         * @param {?} chartModule
         * @return {?}
         */
        chartModule => {
            chartModule(Highcharts);
        }));
    }
}
ChartService.decorators = [
    { type: Injectable }
];
/** @nocollapse */
ChartService.ctorParameters = () => [
    { type: Array, decorators: [{ type: Inject, args: [HIGHCHARTS_MODULES,] }] }
];
if (false) {
    /**
     * @type {?}
     * @private
     */
    ChartService.prototype.chartModules;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2hhcnQuc2VydmljZS5qcyIsInNvdXJjZVJvb3QiOiJuZzovL2FuZ3VsYXItaGlnaGNoYXJ0cy8iLCJzb3VyY2VzIjpbImxpYi9jaGFydC5zZXJ2aWNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7OztBQVFBLE9BQU8sRUFBRSxNQUFNLEVBQUUsVUFBVSxFQUFFLGNBQWMsRUFBRSxNQUFNLGVBQWUsQ0FBQztBQUNuRSxPQUFPLEtBQUssVUFBVSxNQUFNLFlBQVksQ0FBQzs7QUFFekMsTUFBTSxLQUFLLGtCQUFrQixHQUFHLElBQUksY0FBYyxDQUFRLG1CQUFtQixDQUFDO0FBRzlFLE1BQU0sT0FBTyxZQUFZOzs7O0lBQ3ZCLFlBQWdELFlBQW1CO1FBQW5CLGlCQUFZLEdBQVosWUFBWSxDQUFPO0lBQUksQ0FBQzs7OztJQUV4RSxXQUFXO1FBQ1QsSUFBSSxDQUFDLFlBQVksQ0FBQyxPQUFPOzs7O1FBQUMsV0FBVyxDQUFDLEVBQUU7WUFDdEMsV0FBVyxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQzFCLENBQUMsRUFBQyxDQUFDO0lBQ0wsQ0FBQzs7O1lBUkYsVUFBVTs7Ozt3Q0FFSSxNQUFNLFNBQUMsa0JBQWtCOzs7Ozs7O0lBQTFCLG9DQUF1RCIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBGZWxpeCBJdHplbnBsaXR6LiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIFVzZSBvZiB0aGlzIHNvdXJjZSBjb2RlIGlzIGdvdmVybmVkIGJ5IGFuIE1JVC1zdHlsZSBsaWNlbnNlIHRoYXQgY2FuIGJlXG4gKiBmb3VuZCBpbiB0aGUgTElDRU5TRSBmaWxlIGF0XG4gKiBodHRwczovL2dpdGh1Yi5jb20vY2Vib3IvYW5ndWxhci1oaWdoY2hhcnRzL2Jsb2IvbWFzdGVyL0xJQ0VOU0VcbiAqL1xuaW1wb3J0IHsgSW5qZWN0LCBJbmplY3RhYmxlLCBJbmplY3Rpb25Ub2tlbiB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0ICogYXMgSGlnaGNoYXJ0cyBmcm9tICdoaWdoY2hhcnRzJztcblxuZXhwb3J0IGxldCBISUdIQ0hBUlRTX01PRFVMRVMgPSBuZXcgSW5qZWN0aW9uVG9rZW48YW55W10+KCdIaWdoY2hhcnRzTW9kdWxlcycpO1xuXG5ASW5qZWN0YWJsZSgpXG5leHBvcnQgY2xhc3MgQ2hhcnRTZXJ2aWNlIHtcbiAgY29uc3RydWN0b3IoQEluamVjdChISUdIQ0hBUlRTX01PRFVMRVMpIHByaXZhdGUgY2hhcnRNb2R1bGVzOiBhbnlbXSkgeyB9XG5cbiAgaW5pdE1vZHVsZXMoKSB7XG4gICAgdGhpcy5jaGFydE1vZHVsZXMuZm9yRWFjaChjaGFydE1vZHVsZSA9PiB7XG4gICAgICBjaGFydE1vZHVsZShIaWdoY2hhcnRzKTtcbiAgICB9KTtcbiAgfVxufVxuIl19