/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as Highcharts from 'highcharts';
import { AsyncSubject } from 'rxjs';
/**
 * @license
 * Copyright Felix Itzenplitz. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at
 * https://github.com/cebor/angular-highcharts/blob/master/LICENSE
 */
export class MapChart {
    /**
     * @param {?=} options
     */
    constructor(options = { series: [] }) {
        this.options = options;
        this.refSubject = new AsyncSubject();
        this.ref$ = this.refSubject.asObservable();
    }
    /**
     * @param {?} el
     * @return {?}
     */
    init(el) {
        if (!this.ref) {
            Highcharts.mapChart(el.nativeElement, this.options, (/**
             * @param {?} chart
             * @return {?}
             */
            chart => {
                this.refSubject.next(chart);
                this.ref = chart;
                this.refSubject.complete();
            }));
        }
    }
    /**
     * @return {?}
     */
    destroy() {
        if (this.ref) {
            this.options = this.ref.options;
            this.ref.destroy();
            this.ref = undefined;
            // new init subject
            this.refSubject = new AsyncSubject();
            this.ref$ = this.refSubject.asObservable();
        }
    }
}
if (false) {
    /**
     * @type {?}
     * @private
     */
    MapChart.prototype.refSubject;
    /** @type {?} */
    MapChart.prototype.ref$;
    /** @type {?} */
    MapChart.prototype.ref;
    /**
     * @type {?}
     * @private
     */
    MapChart.prototype.options;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWFwY2hhcnQuanMiLCJzb3VyY2VSb290Ijoibmc6Ly9hbmd1bGFyLWhpZ2hjaGFydHMvIiwic291cmNlcyI6WyJsaWIvbWFwY2hhcnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7OztBQUNBLE9BQU8sS0FBSyxVQUFVLE1BQU0sWUFBWSxDQUFDO0FBRXpDLE9BQU8sRUFBRSxZQUFZLEVBQWMsTUFBTSxNQUFNLENBQUM7Ozs7Ozs7OztBQVVoRCxNQUFNLE9BQU8sUUFBUTs7OztJQUtuQixZQUFvQixVQUE0QixFQUFFLE1BQU0sRUFBRSxFQUFFLEVBQUU7UUFBMUMsWUFBTyxHQUFQLE9BQU8sQ0FBbUM7UUFKdEQsZUFBVSxHQUFpQyxJQUFJLFlBQVksRUFBRSxDQUFDO1FBQ3RFLFNBQUksR0FBK0IsSUFBSSxDQUFDLFVBQVUsQ0FBQyxZQUFZLEVBQUUsQ0FBQztJQUdELENBQUM7Ozs7O0lBRWxFLElBQUksQ0FBQyxFQUFjO1FBQ2pCLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxFQUFFO1lBQ2IsVUFBVSxDQUFDLFFBQVEsQ0FBQyxFQUFFLENBQUMsYUFBYSxFQUFFLElBQUksQ0FBQyxPQUFPOzs7O1lBQUUsS0FBSyxDQUFDLEVBQUU7Z0JBQzFELElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO2dCQUM1QixJQUFJLENBQUMsR0FBRyxHQUFHLEtBQUssQ0FBQztnQkFDakIsSUFBSSxDQUFDLFVBQVUsQ0FBQyxRQUFRLEVBQUUsQ0FBQztZQUM3QixDQUFDLEVBQUMsQ0FBQztTQUNKO0lBQ0gsQ0FBQzs7OztJQUVELE9BQU87UUFDTCxJQUFJLElBQUksQ0FBQyxHQUFHLEVBQUU7WUFDWixJQUFJLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDO1lBQ2hDLElBQUksQ0FBQyxHQUFHLENBQUMsT0FBTyxFQUFFLENBQUM7WUFDbkIsSUFBSSxDQUFDLEdBQUcsR0FBRyxTQUFTLENBQUM7WUFFckIsbUJBQW1CO1lBQ25CLElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxZQUFZLEVBQUUsQ0FBQztZQUNyQyxJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsWUFBWSxFQUFFLENBQUM7U0FDNUM7SUFDSCxDQUFDO0NBQ0Y7Ozs7OztJQTNCQyw4QkFBc0U7O0lBQ3RFLHdCQUFrRTs7SUFDbEUsdUJBQW9COzs7OztJQUVSLDJCQUFrRCIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEVsZW1lbnRSZWYgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCAqIGFzIEhpZ2hjaGFydHMgZnJvbSAnaGlnaGNoYXJ0cyc7XG5pbXBvcnQgKiBhcyBIaWdobWFwcyBmcm9tICdoaWdoY2hhcnRzL2hpZ2htYXBzJztcbmltcG9ydCB7IEFzeW5jU3ViamVjdCwgT2JzZXJ2YWJsZSB9IGZyb20gJ3J4anMnO1xuXG4vKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgRmVsaXggSXR6ZW5wbGl0ei4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdFxuICogaHR0cHM6Ly9naXRodWIuY29tL2NlYm9yL2FuZ3VsYXItaGlnaGNoYXJ0cy9ibG9iL21hc3Rlci9MSUNFTlNFXG4gKi9cbmV4cG9ydCBjbGFzcyBNYXBDaGFydCB7XG4gIHByaXZhdGUgcmVmU3ViamVjdDogQXN5bmNTdWJqZWN0PEhpZ2htYXBzLkNoYXJ0PiA9IG5ldyBBc3luY1N1YmplY3QoKTtcbiAgcmVmJDogT2JzZXJ2YWJsZTxIaWdobWFwcy5DaGFydD4gPSB0aGlzLnJlZlN1YmplY3QuYXNPYnNlcnZhYmxlKCk7XG4gIHJlZjogSGlnaG1hcHMuQ2hhcnQ7XG5cbiAgY29uc3RydWN0b3IocHJpdmF0ZSBvcHRpb25zOiBIaWdobWFwcy5PcHRpb25zID0geyBzZXJpZXM6IFtdIH0pIHt9XG5cbiAgaW5pdChlbDogRWxlbWVudFJlZik6IHZvaWQge1xuICAgIGlmICghdGhpcy5yZWYpIHtcbiAgICAgIEhpZ2hjaGFydHMubWFwQ2hhcnQoZWwubmF0aXZlRWxlbWVudCwgdGhpcy5vcHRpb25zLCBjaGFydCA9PiB7XG4gICAgICAgIHRoaXMucmVmU3ViamVjdC5uZXh0KGNoYXJ0KTtcbiAgICAgICAgdGhpcy5yZWYgPSBjaGFydDtcbiAgICAgICAgdGhpcy5yZWZTdWJqZWN0LmNvbXBsZXRlKCk7XG4gICAgICB9KTtcbiAgICB9XG4gIH1cblxuICBkZXN0cm95KCkge1xuICAgIGlmICh0aGlzLnJlZikge1xuICAgICAgdGhpcy5vcHRpb25zID0gdGhpcy5yZWYub3B0aW9ucztcbiAgICAgIHRoaXMucmVmLmRlc3Ryb3koKTtcbiAgICAgIHRoaXMucmVmID0gdW5kZWZpbmVkO1xuXG4gICAgICAvLyBuZXcgaW5pdCBzdWJqZWN0XG4gICAgICB0aGlzLnJlZlN1YmplY3QgPSBuZXcgQXN5bmNTdWJqZWN0KCk7XG4gICAgICB0aGlzLnJlZiQgPSB0aGlzLnJlZlN1YmplY3QuYXNPYnNlcnZhYmxlKCk7XG4gICAgfVxuICB9XG59XG4iXX0=