/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as Highcharts from 'highcharts';
import { AsyncSubject } from 'rxjs';
/**
 * @license
 * Copyright Felix Itzenplitz. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at
 * https://github.com/cebor/angular-highcharts/blob/master/LICENSE
 *
 * @author Felix Itzenplitz
 * @author Timothy A. Perez (contributor)
 */
export class StockChart {
    /**
     * @param {?=} options
     */
    constructor(options = { series: [] }) {
        this.options = options;
        this.refSubject = new AsyncSubject();
        this.ref$ = this.refSubject.asObservable();
    }
    /**
     * @param {?} el
     * @return {?}
     */
    init(el) {
        if (!this.ref) {
            Highcharts.stockChart(el.nativeElement, this.options, (/**
             * @param {?} chart
             * @return {?}
             */
            chart => {
                this.refSubject.next(chart);
                this.ref = chart;
                this.refSubject.complete();
            }));
        }
    }
    /**
     * @return {?}
     */
    destroy() {
        if (this.ref) {
            this.options = this.ref.options;
            this.ref.destroy();
            this.ref = undefined;
            // new init subject
            this.refSubject = new AsyncSubject();
            this.ref$ = this.refSubject.asObservable();
        }
    }
}
if (false) {
    /**
     * @type {?}
     * @private
     */
    StockChart.prototype.refSubject;
    /** @type {?} */
    StockChart.prototype.ref$;
    /** @type {?} */
    StockChart.prototype.ref;
    /**
     * @type {?}
     * @private
     */
    StockChart.prototype.options;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RvY2tjaGFydC5qcyIsInNvdXJjZVJvb3QiOiJuZzovL2FuZ3VsYXItaGlnaGNoYXJ0cy8iLCJzb3VyY2VzIjpbImxpYi9zdG9ja2NoYXJ0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7QUFDQSxPQUFPLEtBQUssVUFBVSxNQUFNLFlBQVksQ0FBQztBQUV6QyxPQUFPLEVBQUUsWUFBWSxFQUFjLE1BQU0sTUFBTSxDQUFDOzs7Ozs7Ozs7Ozs7QUFjaEQsTUFBTSxPQUFPLFVBQVU7Ozs7SUFJckIsWUFBb0IsVUFBNkIsRUFBRSxNQUFNLEVBQUUsRUFBRSxFQUFFO1FBQTNDLFlBQU8sR0FBUCxPQUFPLENBQW9DO1FBSHZELGVBQVUsR0FBa0MsSUFBSSxZQUFZLEVBQUUsQ0FBQztRQUN2RSxTQUFJLEdBQWdDLElBQUksQ0FBQyxVQUFVLENBQUMsWUFBWSxFQUFFLENBQUM7SUFFRCxDQUFDOzs7OztJQUVuRSxJQUFJLENBQUMsRUFBYztRQUNqQixJQUFJLENBQUMsSUFBSSxDQUFDLEdBQUcsRUFBRTtZQUNiLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRSxDQUFDLGFBQWEsRUFBRSxJQUFJLENBQUMsT0FBTzs7OztZQUFFLEtBQUssQ0FBQyxFQUFFO2dCQUM1RCxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQztnQkFDNUIsSUFBSSxDQUFDLEdBQUcsR0FBRyxLQUFLLENBQUM7Z0JBQ2pCLElBQUksQ0FBQyxVQUFVLENBQUMsUUFBUSxFQUFFLENBQUM7WUFDN0IsQ0FBQyxFQUFDLENBQUM7U0FDSjtJQUNILENBQUM7Ozs7SUFFRCxPQUFPO1FBQ0wsSUFBSSxJQUFJLENBQUMsR0FBRyxFQUFFO1lBQ1osSUFBSSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLE9BQU8sQ0FBQztZQUNoQyxJQUFJLENBQUMsR0FBRyxDQUFDLE9BQU8sRUFBRSxDQUFDO1lBQ25CLElBQUksQ0FBQyxHQUFHLEdBQUcsU0FBUyxDQUFDO1lBRXJCLG1CQUFtQjtZQUNuQixJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksWUFBWSxFQUFFLENBQUM7WUFDckMsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLFlBQVksRUFBRSxDQUFDO1NBQzVDO0lBQ0gsQ0FBQztDQUNGOzs7Ozs7SUExQkMsZ0NBQXVFOztJQUN2RSwwQkFBbUU7O0lBQ25FLHlCQUFxQjs7Ozs7SUFDVCw2QkFBbUQiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBFbGVtZW50UmVmIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgKiBhcyBIaWdoY2hhcnRzIGZyb20gJ2hpZ2hjaGFydHMnO1xuaW1wb3J0ICogYXMgSGlnaHN0b2NrIGZyb20gJ2hpZ2hjaGFydHMvaGlnaHN0b2NrJztcbmltcG9ydCB7IEFzeW5jU3ViamVjdCwgT2JzZXJ2YWJsZSB9IGZyb20gJ3J4anMnO1xuXG5cbi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBGZWxpeCBJdHplbnBsaXR6LiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIFVzZSBvZiB0aGlzIHNvdXJjZSBjb2RlIGlzIGdvdmVybmVkIGJ5IGFuIE1JVC1zdHlsZSBsaWNlbnNlIHRoYXQgY2FuIGJlXG4gKiBmb3VuZCBpbiB0aGUgTElDRU5TRSBmaWxlIGF0XG4gKiBodHRwczovL2dpdGh1Yi5jb20vY2Vib3IvYW5ndWxhci1oaWdoY2hhcnRzL2Jsb2IvbWFzdGVyL0xJQ0VOU0VcbiAqXG4gKiBAYXV0aG9yIEZlbGl4IEl0emVucGxpdHpcbiAqIEBhdXRob3IgVGltb3RoeSBBLiBQZXJleiAoY29udHJpYnV0b3IpXG4gKi9cbmV4cG9ydCBjbGFzcyBTdG9ja0NoYXJ0IHtcbiAgcHJpdmF0ZSByZWZTdWJqZWN0OiBBc3luY1N1YmplY3Q8SGlnaHN0b2NrLkNoYXJ0PiA9IG5ldyBBc3luY1N1YmplY3QoKTtcbiAgcmVmJDogT2JzZXJ2YWJsZTxIaWdoc3RvY2suQ2hhcnQ+ID0gdGhpcy5yZWZTdWJqZWN0LmFzT2JzZXJ2YWJsZSgpO1xuICByZWY6IEhpZ2hzdG9jay5DaGFydDtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSBvcHRpb25zOiBIaWdoc3RvY2suT3B0aW9ucyA9IHsgc2VyaWVzOiBbXSB9KSB7fVxuXG4gIGluaXQoZWw6IEVsZW1lbnRSZWYpOiB2b2lkIHtcbiAgICBpZiAoIXRoaXMucmVmKSB7XG4gICAgICBIaWdoY2hhcnRzLnN0b2NrQ2hhcnQoZWwubmF0aXZlRWxlbWVudCwgdGhpcy5vcHRpb25zLCBjaGFydCA9PiB7XG4gICAgICAgIHRoaXMucmVmU3ViamVjdC5uZXh0KGNoYXJ0KTtcbiAgICAgICAgdGhpcy5yZWYgPSBjaGFydDtcbiAgICAgICAgdGhpcy5yZWZTdWJqZWN0LmNvbXBsZXRlKCk7XG4gICAgICB9KTtcbiAgICB9XG4gIH1cblxuICBkZXN0cm95KCkge1xuICAgIGlmICh0aGlzLnJlZikge1xuICAgICAgdGhpcy5vcHRpb25zID0gdGhpcy5yZWYub3B0aW9ucztcbiAgICAgIHRoaXMucmVmLmRlc3Ryb3koKTtcbiAgICAgIHRoaXMucmVmID0gdW5kZWZpbmVkO1xuXG4gICAgICAvLyBuZXcgaW5pdCBzdWJqZWN0XG4gICAgICB0aGlzLnJlZlN1YmplY3QgPSBuZXcgQXN5bmNTdWJqZWN0KCk7XG4gICAgICB0aGlzLnJlZiQgPSB0aGlzLnJlZlN1YmplY3QuYXNPYnNlcnZhYmxlKCk7XG4gICAgfVxuICB9XG59XG4iXX0=