/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * @license
 * Copyright Felix Itzenplitz. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at
 * https://github.com/cebor/angular-highcharts/blob/master/LICENSE
 */
import { Directive, ElementRef, Input } from '@angular/core';
import { Chart } from './chart';
import { MapChart } from './mapchart';
import { StockChart } from './stockchart';
var ChartDirective = /** @class */ (function () {
    function ChartDirective(el) {
        this.el = el;
    }
    /**
     * @param {?} changes
     * @return {?}
     */
    ChartDirective.prototype.ngOnChanges = /**
     * @param {?} changes
     * @return {?}
     */
    function (changes) {
        if (!changes.chart.isFirstChange()) {
            this.destroy();
            this.init();
        }
    };
    /**
     * @return {?}
     */
    ChartDirective.prototype.ngOnInit = /**
     * @return {?}
     */
    function () {
        this.init();
    };
    /**
     * @return {?}
     */
    ChartDirective.prototype.ngOnDestroy = /**
     * @return {?}
     */
    function () {
        this.destroy();
    };
    /**
     * @private
     * @return {?}
     */
    ChartDirective.prototype.init = /**
     * @private
     * @return {?}
     */
    function () {
        if (this.chart instanceof Chart || this.chart instanceof StockChart || this.chart instanceof MapChart) {
            this.chart.init(this.el);
        }
    };
    /**
     * @private
     * @return {?}
     */
    ChartDirective.prototype.destroy = /**
     * @private
     * @return {?}
     */
    function () {
        if (this.chart instanceof Chart || this.chart instanceof StockChart || this.chart instanceof MapChart) {
            this.chart.destroy();
        }
    };
    ChartDirective.decorators = [
        { type: Directive, args: [{
                    selector: '[chart]'
                },] }
    ];
    /** @nocollapse */
    ChartDirective.ctorParameters = function () { return [
        { type: ElementRef }
    ]; };
    ChartDirective.propDecorators = {
        chart: [{ type: Input }]
    };
    return ChartDirective;
}());
export { ChartDirective };
if (false) {
    /** @type {?} */
    ChartDirective.prototype.chart;
    /**
     * @type {?}
     * @private
     */
    ChartDirective.prototype.el;
}
//# sourceMappingURL=data:application/json;base64,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