import * as tslib_1 from "tslib";
import { Inject, Injectable, Pipe } from '@angular/core';
import { I18NEXT_SERVICE } from './I18NEXT_TOKENS';
let I18NextFormatPipe = class I18NextFormatPipe {
    constructor(translateI18Next) {
        this.translateI18Next = translateI18Next;
    }
    transform(value, options) {
        let opts = typeof (options) === 'string' ? { format: options } : options;
        return this.translateI18Next.format(value, opts.format, opts.lng);
    }
};
I18NextFormatPipe = tslib_1.__decorate([
    Injectable(),
    Pipe({
        name: 'i18nextFormat'
    }),
    tslib_1.__param(0, Inject(I18NEXT_SERVICE)),
    tslib_1.__metadata("design:paramtypes", [Object])
], I18NextFormatPipe);
export { I18NextFormatPipe };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiSTE4TmV4dEZvcm1hdFBpcGUuanMiLCJzb3VyY2VSb290Ijoibmc6Ly9hbmd1bGFyLWkxOG5leHQvIiwic291cmNlcyI6WyJJMThOZXh0Rm9ybWF0UGlwZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsT0FBTyxFQUFFLE1BQU0sRUFBRSxVQUFVLEVBQUUsSUFBSSxFQUFpQixNQUFNLGVBQWUsQ0FBQztBQUV4RSxPQUFPLEVBQUUsZUFBZSxFQUFFLE1BQU0sa0JBQWtCLENBQUM7QUFPbkQsSUFBYSxpQkFBaUIsR0FBOUIsTUFBYSxpQkFBaUI7SUFFNUIsWUFDcUMsZ0JBQXFDO1FBQXJDLHFCQUFnQixHQUFoQixnQkFBZ0IsQ0FBcUI7SUFDdkUsQ0FBQztJQUVHLFNBQVMsQ0FBQyxLQUFVLEVBQUUsT0FBd0I7UUFDbkQsSUFBSSxJQUFJLEdBQVEsT0FBTSxDQUFDLE9BQU8sQ0FBQyxLQUFLLFFBQVEsQ0FBQyxDQUFDLENBQUMsRUFBRSxNQUFNLEVBQUUsT0FBTyxFQUFFLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQztRQUM3RSxPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO0lBQ3BFLENBQUM7Q0FDRixDQUFBO0FBVlksaUJBQWlCO0lBSjdCLFVBQVUsRUFBRTtJQUNaLElBQUksQ0FBQztRQUNGLElBQUksRUFBRSxlQUFlO0tBQ3hCLENBQUM7SUFJSyxtQkFBQSxNQUFNLENBQUMsZUFBZSxDQUFDLENBQUE7O0dBSGpCLGlCQUFpQixDQVU3QjtTQVZZLGlCQUFpQiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEluamVjdCwgSW5qZWN0YWJsZSwgUGlwZSwgUGlwZVRyYW5zZm9ybSB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xyXG5cclxuaW1wb3J0IHsgSTE4TkVYVF9TRVJWSUNFIH0gZnJvbSAnLi9JMThORVhUX1RPS0VOUyc7XHJcbmltcG9ydCB7IElUcmFuc2xhdGlvblNlcnZpY2UgfSBmcm9tICcuL0lUcmFuc2xhdGlvblNlcnZpY2UnO1xyXG5cclxuQEluamVjdGFibGUoKVxyXG5AUGlwZSh7XHJcbiAgICBuYW1lOiAnaTE4bmV4dEZvcm1hdCdcclxufSlcclxuZXhwb3J0IGNsYXNzIEkxOE5leHRGb3JtYXRQaXBlIGltcGxlbWVudHMgUGlwZVRyYW5zZm9ybSB7XHJcblxyXG4gIGNvbnN0cnVjdG9yKFxyXG4gICAgICBASW5qZWN0KEkxOE5FWFRfU0VSVklDRSkgcHJpdmF0ZSB0cmFuc2xhdGVJMThOZXh0OiBJVHJhbnNsYXRpb25TZXJ2aWNlXHJcbiAgKSB7fVxyXG5cclxuICBwdWJsaWMgdHJhbnNmb3JtKHZhbHVlOiBhbnksIG9wdGlvbnM6IE9iamVjdCB8IHN0cmluZyk6IHN0cmluZyB7XHJcbiAgICBsZXQgb3B0czogYW55ID0gdHlwZW9mKG9wdGlvbnMpID09PSAnc3RyaW5nJyA/IHsgZm9ybWF0OiBvcHRpb25zIH0gOiBvcHRpb25zO1xyXG4gICAgcmV0dXJuIHRoaXMudHJhbnNsYXRlSTE4TmV4dC5mb3JtYXQodmFsdWUsIG9wdHMuZm9ybWF0LCBvcHRzLmxuZyk7XHJcbiAgfVxyXG59XHJcbiJdfQ==